/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.allbrick;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.AllBrickStairBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class AllBrickStairBlockStateProvider
extends BlockStateProvider {
    public AllBrickStairBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.getInstance().getAllBrickStairBlocks().forEach(this::registerStatesAndModelsFor);
    }

    private void registerStatesAndModelsFor(AllBrickStairBlock allBrickStairBlock) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(allBrickStairBlock);
        for (Direction facingValue : StairBlock.FACING.getPossibleValues()) {
            for (StairsShape shapeValue : ShingleBlock.SHAPE.getPossibleValues()) {
                for (Half halfValue : StairBlock.HALF.getPossibleValues()) {
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/allbrick/" + allBrickStairBlock.getRegistryName().getPath() + AllBrickStairBlockStateProvider.getTypeFromShape(shapeValue), this.modLoc("block/allbrick/" + allBrickStairBlock.getRegistryName().getPath() + AllBrickStairBlockStateProvider.getTypeFromShape(shapeValue) + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end()).rotationX(halfValue == Half.TOP ? 180 : 0).rotationY(this.getYFromFacing(facingValue) + this.getYFromShape(shapeValue) + this.getYFromHalf(halfValue, shapeValue)).addModel()).condition((Property)StairBlock.FACING, (Comparable[])new Direction[]{facingValue}).condition((Property)StairBlock.SHAPE, (Comparable[])new StairsShape[]{shapeValue}).condition((Property)StairBlock.HALF, (Comparable[])new Half[]{halfValue}).end();
                }
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((MateriallyTexturedModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(allBrickStairBlock.getRegistryName().getPath(), this.modLoc("block/allbrick/" + allBrickStairBlock.getRegistryName().getPath()))).customLoader(MateriallyTexturedModelBuilder::new)).end();
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @NotNull
    public String getName() {
        return "All Brick Stair BlockStates Provider";
    }

    private int getYFromHalf(Half half, StairsShape shape) {
        if (half == Half.TOP) {
            if (shape == StairsShape.STRAIGHT) {
                return 0;
            }
            return 90;
        }
        return 0;
    }

    private int getYFromShape(StairsShape shape) {
        return switch (shape) {
            default -> 0;
            case StairsShape.OUTER_LEFT, StairsShape.INNER_LEFT -> -90;
        };
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 90;
            case Direction.WEST -> 180;
            case Direction.NORTH -> 270;
            case Direction.EAST -> 0;
        };
    }

    private static String getTypeFromShape(StairsShape shape) {
        return switch (shape) {
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> "_inner";
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> "_outer";
            default -> "";
        };
    }
}

