/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.shingle.slab;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.ldtteam.domumornamentum.block.types.ShingleSlabShapeType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ShingleSlabBlockStateProvider
extends BlockStateProvider {
    public ShingleSlabBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createBlockstateFile(ModBlocks.getInstance().getShingleSlab());
    }

    private void createBlockstateFile(ShingleSlabBlock shingle) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)shingle);
        EnumMap<ShingleSlabShapeType, ModelFile> models = new EnumMap<ShingleSlabShapeType, ModelFile>(ShingleSlabShapeType.class);
        for (Direction facingValue : StairBlock.FACING.getPossibleValues()) {
            for (ShingleSlabShapeType shapeValue : ShingleSlabBlock.SHAPE.getPossibleValues()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(models.computeIfAbsent(shapeValue, shape -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/shingle_slab/" + shapeValue.name().toLowerCase(), this.modLoc("block/shingle_slab/shingle_slab_" + shapeValue.name().toLowerCase() + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end())).uvLock(false).rotationY(this.getYFromFacing(facingValue)).addModel()).condition((Property)StairBlock.FACING, (Comparable[])new Direction[]{facingValue}).condition(ShingleSlabBlock.SHAPE, (Comparable[])new ShingleSlabShapeType[]{shapeValue}).end();
            }
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(shingle.getRegistryName().getPath())).parent((ModelFile)models.get((Object)ShingleSlabShapeType.TOP));
        ModelBuilderUtils.applyDefaultItemTransforms(itemModelBuilder);
    }

    @NotNull
    public String getName() {
        return "Shingle Slabs BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 0;
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
        };
    }
}

