/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.desiredservers;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.kreezcraft.desiredservers.Constants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;

public class CommonClass {
    private static FileReader serversFile;

    public static void onInitializeClient() {
        File featuredServerList;
        File configFolder = new File(Minecraft.getInstance().gameDirectory, "config/desiredservers");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(featuredServerList = new File(configFolder, "desiredservers.json")).exists()) {
            try {
                featuredServerList.createNewFile();
                FileWriter writer = new FileWriter(featuredServerList);
                writer.write("[\n  {\n    \"serverName\": \"Featured Server\",\n    \"serverIP\": \"127.0.0.1\",\n    \"forceResourcePack\": \"true\"\n  },\n  {\n    \"serverName\": \"Another Server!\",\n    \"serverIP\": \"192.168.1.1\",\n    \"forceResourcePack\": \"false\"\n  }\n]");
                writer.close();
            }
            catch (Throwable t) {
                Constants.LOG.error("Could create the default config file for Featured Servers Deus Ex\nException was: " + t.getMessage());
                return;
            }
        }
        try {
            serversFile = new FileReader(featuredServerList.getPath());
        }
        catch (Throwable t) {
            Constants.LOG.error("Could create the default config file for Featured Servers Deus Ex\nException was: " + t.getMessage());
            return;
        }
        Gson gson = new Gson();
        JsonReader reader = new JsonReader((Reader)serversFile);
        ServerDataHelper[] featuredList = (ServerDataHelper[])gson.fromJson(reader, ServerDataHelper[].class);
        if (featuredList == null) {
            return;
        }
        ServerList serverList = new ServerList(Minecraft.getInstance());
        serverList.load();
        int oldSize = serverList.size();
        int n = featuredList.length;
        ArrayList<String> existingServers = new ArrayList<String>();
        for (int n2 = 0; n2 < n; ++n2) {
            ServerDataHelper serverhelp = featuredList[n2];
            ServerData server = new ServerData(serverhelp.serverName, serverhelp.serverIP, ServerData.Type.OTHER);
            if (serverhelp.forceResourcePack != null && serverhelp.forceResourcePack.booleanValue()) {
                server.setResourcePackStatus(ServerData.ServerPackStatus.ENABLED);
            }
            if (CommonClass.inList(server, serverList)) {
                existingServers.add(server.name);
                continue;
            }
            Constants.LOG.info("Adding featured server {}", (Object)server.name);
            serverList.add(server, false);
        }
        if (!existingServers.isEmpty()) {
            Constants.LOG.info("The following featured servers were already in server list: {}", existingServers);
        }
        if (oldSize != serverList.size()) {
            serverList.save();
        }
    }

    public static boolean inList(ServerData server, ServerList list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            ServerData data = list.get(i);
            if (!data.ip.equalsIgnoreCase(server.ip) || !data.name.equalsIgnoreCase(server.name)) continue;
            return true;
        }
        return false;
    }

    public static class ServerDataHelper {
        public String serverName;
        public String serverIP;
        public Boolean forceResourcePack;
    }
}

