/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.features;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.blocks.BloomingStemBlock;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BloomingStemFeature
extends Feature<NoneFeatureConfiguration> {
    private final List<Direction> DIRECTIONS = Arrays.stream(Direction.values()).filter(direction -> direction.get3DDataValue() > 0).toList();
    private final List<Direction> history = new ArrayList<Direction>(Stream.generate(() -> Direction.UP).limit(5L).toList());

    public BloomingStemFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        if (!level.getBlockState(origin.below()).is((Block)DDBlocks.BLOOMING_SCULK_STONE.get())) {
            return false;
        }
        if (!level.getBlockState(origin.above()).isAir()) {
            return false;
        }
        int branches = random.nextIntBetweenInclusive(1, 2);
        int length = random.nextIntBetweenInclusive(6, 20);
        double probability = (double)branches / (double)length;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(origin.getX(), origin.getY(), origin.getZ());
        Direction direction = Direction.UP;
        Direction nextDirection = Direction.UP;
        for (int i = 0; i < length && level.getBlockState((BlockPos)blockPos).isAir() && level.getBlockState(blockPos.relative(nextDirection)).isAir(); ++i) {
            this.history.set(i % 5, direction);
            Direction branchDirection = null;
            if (i > 6 && direction == Direction.UP && random.nextDouble() < probability) {
                BlockPos.MutableBlockPos branchBlockPos = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                branchDirection = Direction.values()[random.nextIntBetweenInclusive(2, 5)];
                branchBlockPos.move(branchDirection);
                level.setBlock((BlockPos)branchBlockPos, this.stemPlacement(branchDirection, branchDirection.getOpposite(), null), 3);
                probability /= 2.0;
            }
            level.setBlock((BlockPos)blockPos, this.stemPlacement(direction, nextDirection, branchDirection), 3);
            direction = nextDirection;
            nextDirection = nextDirection.getAxis().isHorizontal() ? Direction.UP : this.randomDirection(random);
            blockPos.move(direction);
        }
        level.setBlock((BlockPos)blockPos, this.stemPlacement(direction, direction.getOpposite(), null), 3);
        return true;
    }

    private Direction randomDirection(RandomSource random) {
        ArrayList<Direction> list = new ArrayList<Direction>(this.DIRECTIONS);
        for (Direction d : this.history) {
            list.remove(d);
            list.remove(d.getOpposite());
        }
        int dir = 0;
        float chance = 1.0f - 0.125f * (float)list.size();
        float f = random.nextFloat();
        while (chance < f) {
            chance += 0.125f;
            ++dir;
        }
        list.addFirst(Direction.UP);
        return (Direction)list.get(dir);
    }

    private BlockState stemPlacement(Direction direction, Direction nextDirection, Direction branchDirection) {
        BlockState stem = (BlockState)((BlockState)((BlockState)((Block)DDBlocks.BLOOMING_STEM.get()).defaultBlockState().setValue((Property)BloomingStemBlock.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(nextDirection), (Comparable)Boolean.valueOf(true));
        if (branchDirection == null) {
            return stem;
        }
        return (BlockState)stem.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(branchDirection), (Comparable)Boolean.valueOf(true));
    }
}

