/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.items;

import com.kyanite.deeperdarker.content.entities.DDBoat;
import com.kyanite.deeperdarker.content.entities.DDChestBoat;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DDBoatItem
extends BoatItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final String WOOD_TYPE;
    private final boolean HAS_CHEST;

    public DDBoatItem(boolean hasChest, Item.Properties properties, WoodType woodType) {
        super(hasChest, Boat.Type.MANGROVE, properties);
        this.WOOD_TYPE = woodType.name();
        this.HAS_CHEST = hasChest;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = DDBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(level, (HitResult)hitresult);
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private Boat getBoat(Level level, HitResult hitResult) {
        return this.HAS_CHEST ? new DDChestBoat(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z, this.WOOD_TYPE) : new DDBoat(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z, this.WOOD_TYPE);
    }
}

