/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content;

import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.content.blocks.AncientVaseBlock;
import com.kyanite.deeperdarker.content.blocks.BloomingStemBlock;
import com.kyanite.deeperdarker.content.blocks.CrystallizedAmberBlock;
import com.kyanite.deeperdarker.content.blocks.GeyserBlock;
import com.kyanite.deeperdarker.content.blocks.GloomySculkBlock;
import com.kyanite.deeperdarker.content.blocks.InfestedSculkBlock;
import com.kyanite.deeperdarker.content.blocks.OthersidePortalBlock;
import com.kyanite.deeperdarker.content.blocks.SculkJawBlock;
import com.kyanite.deeperdarker.content.blocks.entity.DDHangingSignBlockEntity;
import com.kyanite.deeperdarker.content.blocks.entity.DDSignBlockEntity;
import com.kyanite.deeperdarker.content.blocks.flammable.FlammableBlock;
import com.kyanite.deeperdarker.content.blocks.flammable.FlammableFenceBlock;
import com.kyanite.deeperdarker.content.blocks.flammable.FlammableFenceGateBlock;
import com.kyanite.deeperdarker.content.blocks.flammable.FlammableLeavesBlock;
import com.kyanite.deeperdarker.content.blocks.flammable.FlammableSlabBlock;
import com.kyanite.deeperdarker.content.blocks.flammable.FlammableStairBlock;
import com.kyanite.deeperdarker.content.blocks.flammable.RotatedFlammableBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GloomyCactusBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GloomyGrassBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingFlowersBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingGrassBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingRootsBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingRootsPlantBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingVinesBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.GlowingVinesPlantBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.IceLilyBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.LilyFlowerBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.SculkTendrilsBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.SculkTendrilsPlantBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.SculkVinesBlock;
import com.kyanite.deeperdarker.content.blocks.vegetation.SculkVinesPlantBlock;
import com.kyanite.deeperdarker.world.DDConfiguredFeatures;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DDBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"deeperdarker");
    private static final BlockSetType ECHO_SET = BlockSetType.register((BlockSetType)new BlockSetType("echo"));
    public static final WoodType ECHO = WoodType.register((WoodType)new WoodType("echo", ECHO_SET));
    public static final DeferredBlock<RotatedPillarBlock> ECHO_LOG = DDBlocks.register("echo_log", () -> new RotatedFlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor.COLOR_LIGHT_GRAY : MapColor.COLOR_PURPLE), 5, 5));
    public static final DeferredBlock<RotatedPillarBlock> ECHO_WOOD = DDBlocks.register("echo_wood", () -> new RotatedFlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(MapColor.COLOR_PURPLE), 5, 5));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_ECHO_LOG = DDBlocks.register("stripped_echo_log", () -> new RotatedFlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(MapColor.COLOR_LIGHT_GRAY), 5, 5));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_ECHO_WOOD = DDBlocks.register("stripped_echo_wood", () -> new RotatedFlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(MapColor.COLOR_LIGHT_GRAY), 5, 5));
    public static final DeferredBlock<Block> ECHO_PLANKS = DDBlocks.register("echo_planks", () -> new FlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(MapColor.COLOR_LIGHT_GRAY), 20, 5));
    public static final DeferredBlock<StairBlock> ECHO_STAIRS = DDBlocks.register("echo_stairs", () -> new FlammableStairBlock(((Block)ECHO_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(MapColor.COLOR_LIGHT_GRAY), 20, 5));
    public static final DeferredBlock<SlabBlock> ECHO_SLAB = DDBlocks.register("echo_slab", () -> new FlammableSlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).mapColor(MapColor.COLOR_LIGHT_GRAY), 20, 5));
    public static final DeferredBlock<FenceBlock> ECHO_FENCE = DDBlocks.register("echo_fence", () -> new FlammableFenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).mapColor(MapColor.COLOR_LIGHT_GRAY), 20, 5));
    public static final DeferredBlock<FenceGateBlock> ECHO_FENCE_GATE = DDBlocks.register("echo_fence_gate", () -> new FlammableFenceGateBlock(ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(MapColor.COLOR_LIGHT_GRAY), 20, 5));
    public static final DeferredBlock<DoorBlock> ECHO_DOOR = DDBlocks.register("echo_door", () -> new DoorBlock(ECHO_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<TrapDoorBlock> ECHO_TRAPDOOR = DDBlocks.register("echo_trapdoor", () -> new TrapDoorBlock(ECHO_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<PressurePlateBlock> ECHO_PRESSURE_PLATE = DDBlocks.register("echo_pressure_plate", () -> new PressurePlateBlock(ECHO_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<ButtonBlock> ECHO_BUTTON = DDBlocks.register("echo_button", () -> new ButtonBlock(ECHO_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    public static final DeferredBlock<LeavesBlock> ECHO_LEAVES = DDBlocks.register("echo_leaves", () -> new FlammableLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.COLOR_PURPLE), 60, 30));
    public static final TreeGrower ECHO_TREE = new TreeGrower("echo", Optional.empty(), Optional.of(DDConfiguredFeatures.TREE_ECHO), Optional.empty());
    public static final DeferredBlock<SaplingBlock> ECHO_SAPLING = DDBlocks.register("echo_sapling", () -> new SaplingBlock(ECHO_TREE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)){

        protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
            return pState.is((Block)ECHO_SOIL.get()) || pState.is((Block)SCULK_GRIME.get());
        }
    });
    public static final DeferredBlock<StandingSignBlock> ECHO_SIGN = BLOCKS.register("echo_sign", () -> new StandingSignBlock(ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<WallSignBlock> ECHO_WALL_SIGN = BLOCKS.register("echo_wall_sign", () -> new WallSignBlock(ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).lootFrom(ECHO_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<CeilingHangingSignBlock> ECHO_HANGING_SIGN = BLOCKS.register("echo_hanging_sign", () -> new CeilingHangingSignBlock(ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDHangingSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<WallHangingSignBlock> ECHO_WALL_HANGING_SIGN = BLOCKS.register("echo_wall_hanging_sign", () -> new WallHangingSignBlock(ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN).lootFrom(ECHO_HANGING_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDHangingSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<Block> POTTED_ECHO_SAPLING = BLOCKS.register("potted_echo_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, ECHO_SAPLING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_OAK_SAPLING)));
    private static final BlockSetType BLOOM_SET = BlockSetType.register((BlockSetType)new BlockSetType("bloom"));
    public static final WoodType BLOOM = WoodType.register((WoodType)new WoodType("bloom", BLOOM_SET));
    public static final DeferredBlock<Block> BLOOMING_STEM = DDBlocks.register("blooming_stem", () -> new BloomingStemBlock(BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.WOOD).mapColor(MapColor.COLOR_CYAN).ignitedByLava().noOcclusion()));
    public static final DeferredBlock<Block> STRIPPED_BLOOMING_STEM = DDBlocks.register("stripped_blooming_stem", () -> new BloomingStemBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BLOOMING_STEM.get())).mapColor(MapColor.GLOW_LICHEN)));
    public static final DeferredBlock<Block> BLOOM_PLANKS = DDBlocks.register("bloom_planks", () -> new FlammableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(MapColor.GLOW_LICHEN), 20, 5));
    public static final DeferredBlock<StairBlock> BLOOM_STAIRS = DDBlocks.register("bloom_stairs", () -> new FlammableStairBlock(((Block)BLOOM_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(MapColor.GLOW_LICHEN), 20, 5));
    public static final DeferredBlock<SlabBlock> BLOOM_SLAB = DDBlocks.register("bloom_slab", () -> new FlammableSlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).mapColor(MapColor.GLOW_LICHEN), 20, 5));
    public static final DeferredBlock<FenceBlock> BLOOM_FENCE = DDBlocks.register("bloom_fence", () -> new FlammableFenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).mapColor(MapColor.GLOW_LICHEN), 20, 5));
    public static final DeferredBlock<FenceGateBlock> BLOOM_FENCE_GATE = DDBlocks.register("bloom_fence_gate", () -> new FlammableFenceGateBlock(BLOOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(MapColor.GLOW_LICHEN), 20, 5));
    public static final DeferredBlock<DoorBlock> BLOOM_DOOR = DDBlocks.register("bloom_door", () -> new DoorBlock(BLOOM_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).mapColor(MapColor.GLOW_LICHEN)));
    public static final DeferredBlock<TrapDoorBlock> BLOOM_TRAPDOOR = DDBlocks.register("bloom_trapdoor", () -> new TrapDoorBlock(BLOOM_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).mapColor(MapColor.GLOW_LICHEN)));
    public static final DeferredBlock<PressurePlateBlock> BLOOM_PRESSURE_PLATE = DDBlocks.register("bloom_pressure_plate", () -> new PressurePlateBlock(BLOOM_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).mapColor(MapColor.GLOW_LICHEN)));
    public static final DeferredBlock<ButtonBlock> BLOOM_BUTTON = DDBlocks.register("bloom_button", () -> new ButtonBlock(BLOOM_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    public static final DeferredBlock<StandingSignBlock> BLOOM_SIGN = BLOCKS.register("bloom_sign", () -> new StandingSignBlock(BLOOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN).mapColor(MapColor.GLOW_LICHEN)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<WallSignBlock> BLOOM_WALL_SIGN = BLOCKS.register("bloom_wall_sign", () -> new WallSignBlock(BLOOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN).lootFrom(BLOOM_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<CeilingHangingSignBlock> BLOOM_HANGING_SIGN = BLOCKS.register("bloom_hanging_sign", () -> new CeilingHangingSignBlock(BLOOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDHangingSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<WallHangingSignBlock> BLOOM_WALL_HANGING_SIGN = BLOCKS.register("bloom_wall_hanging_sign", () -> new WallHangingSignBlock(BLOOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN).lootFrom(BLOOM_HANGING_SIGN).mapColor(MapColor.COLOR_LIGHT_GRAY)){

        public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
            return new DDHangingSignBlockEntity(pPos, pState);
        }
    });
    public static final DeferredBlock<Block> POTTED_BLOOMING_STEM = BLOCKS.register("potted_blooming_stem", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BLOOMING_STEM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_OAK_SAPLING)));
    public static final DeferredBlock<Block> SCULK_STONE = DDBlocks.register("sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound((SoundType)DDSounds.SCULK_STONE).mapColor(MapColor.COLOR_CYAN).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> SCULK_STONE_STAIRS = DDBlocks.register("sculk_stone_stairs", () -> new StairBlock(((Block)SCULK_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<SlabBlock> SCULK_STONE_SLAB = DDBlocks.register("sculk_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<WallBlock> SCULK_STONE_WALL = DDBlocks.register("sculk_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> COBBLED_SCULK_STONE = DDBlocks.register("cobbled_sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<StairBlock> COBBLED_SCULK_STONE_STAIRS = DDBlocks.register("cobbled_sculk_stone_stairs", () -> new StairBlock(((Block)COBBLED_SCULK_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_SCULK_STONE.get()))));
    public static final DeferredBlock<SlabBlock> COBBLED_SCULK_STONE_SLAB = DDBlocks.register("cobbled_sculk_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_SCULK_STONE.get()))));
    public static final DeferredBlock<WallBlock> COBBLED_SCULK_STONE_WALL = DDBlocks.register("cobbled_sculk_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_SCULK_STONE.get()))));
    public static final DeferredBlock<Block> POLISHED_SCULK_STONE = DDBlocks.register("polished_sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<StairBlock> POLISHED_SCULK_STONE_STAIRS = DDBlocks.register("polished_sculk_stone_stairs", () -> new StairBlock(((Block)POLISHED_SCULK_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_SCULK_STONE.get()))));
    public static final DeferredBlock<SlabBlock> POLISHED_SCULK_STONE_SLAB = DDBlocks.register("polished_sculk_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_SCULK_STONE.get()))));
    public static final DeferredBlock<WallBlock> POLISHED_SCULK_STONE_WALL = DDBlocks.register("polished_sculk_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_BRICKS = DDBlocks.register("sculk_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<StairBlock> SCULK_STONE_BRICK_STAIRS = DDBlocks.register("sculk_stone_brick_stairs", () -> new StairBlock(((Block)SCULK_STONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE_BRICKS.get()))));
    public static final DeferredBlock<SlabBlock> SCULK_STONE_BRICK_SLAB = DDBlocks.register("sculk_stone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE_BRICKS.get()))));
    public static final DeferredBlock<WallBlock> SCULK_STONE_BRICK_WALL = DDBlocks.register("sculk_stone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE_BRICKS.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_TILES = DDBlocks.register("sculk_stone_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<StairBlock> SCULK_STONE_TILE_STAIRS = DDBlocks.register("sculk_stone_tile_stairs", () -> new StairBlock(((Block)SCULK_STONE_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE_TILES.get()))));
    public static final DeferredBlock<SlabBlock> SCULK_STONE_TILE_SLAB = DDBlocks.register("sculk_stone_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE_TILES.get()))));
    public static final DeferredBlock<WallBlock> SCULK_STONE_TILE_WALL = DDBlocks.register("sculk_stone_tile_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE_TILES.get()))));
    public static final DeferredBlock<Block> SMOOTH_SCULK_STONE = DDBlocks.register("smooth_sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<StairBlock> SMOOTH_SCULK_STONE_STAIRS = DDBlocks.register("smooth_sculk_stone_stairs", () -> new StairBlock(((Block)SMOOTH_SCULK_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOOTH_SCULK_STONE.get()))));
    public static final DeferredBlock<SlabBlock> SMOOTH_SCULK_STONE_SLAB = DDBlocks.register("smooth_sculk_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOOTH_SCULK_STONE.get()))));
    public static final DeferredBlock<WallBlock> SMOOTH_SCULK_STONE_WALL = DDBlocks.register("smooth_sculk_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOOTH_SCULK_STONE.get()))));
    public static final DeferredBlock<Block> CUT_SCULK_STONE = DDBlocks.register("cut_sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<StairBlock> CUT_SCULK_STONE_STAIRS = DDBlocks.register("cut_sculk_stone_stairs", () -> new StairBlock(((Block)CUT_SCULK_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_SCULK_STONE.get()))));
    public static final DeferredBlock<SlabBlock> CUT_SCULK_STONE_SLAB = DDBlocks.register("cut_sculk_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_SCULK_STONE.get()))));
    public static final DeferredBlock<WallBlock> CUT_SCULK_STONE_WALL = DDBlocks.register("cut_sculk_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_SCULK_STONE.get()))));
    public static final DeferredBlock<Block> CHISELED_SCULK_STONE = DDBlocks.register("chiseled_sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_GRIME = DDBlocks.register("sculk_grime", () -> new MudBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).strength(0.6f).mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<Block> SCULK_GRIME_BRICKS = DDBlocks.register("sculk_grime_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).mapColor(MapColor.TERRACOTTA_GREEN)));
    public static final DeferredBlock<SlabBlock> SCULK_GRIME_BRICK_SLAB = DDBlocks.register("sculk_grime_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_GRIME_BRICKS.get()))));
    public static final DeferredBlock<StairBlock> SCULK_GRIME_BRICK_STAIRS = DDBlocks.register("sculk_grime_brick_stairs", () -> new StairBlock(((Block)SCULK_GRIME_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_GRIME_BRICKS.get()))));
    public static final DeferredBlock<WallBlock> SCULK_GRIME_BRICK_WALL = DDBlocks.register("sculk_grime_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_GRIME_BRICKS.get()))));
    public static final DeferredBlock<Block> BLOOMING_SCULK_STONE = DDBlocks.register("blooming_sculk_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get())).strength(1.5f, 4.0f).mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<Block> BLOOMING_MOSS_BLOCK = DDBlocks.register("blooming_moss_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).sound(SoundType.SCULK).mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<Block> ECHO_SOIL = DDBlocks.register("echo_soil", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).strength(0.3f).mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<Block> GLOOMSLATE = DDBlocks.register("gloomslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(2.5f, 4.5f).mapColor(MapColor.TERRACOTTA_BROWN).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> GLOOMSLATE_STAIRS = DDBlocks.register("gloomslate_stairs", () -> new StairBlock(((Block)GLOOMSLATE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<SlabBlock> GLOOMSLATE_SLAB = DDBlocks.register("gloomslate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<WallBlock> GLOOMSLATE_WALL = DDBlocks.register("gloomslate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> COBBLED_GLOOMSLATE = DDBlocks.register("cobbled_gloomslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<StairBlock> COBBLED_GLOOMSLATE_STAIRS = DDBlocks.register("cobbled_gloomslate_stairs", () -> new StairBlock(((Block)COBBLED_GLOOMSLATE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_GLOOMSLATE.get()))));
    public static final DeferredBlock<SlabBlock> COBBLED_GLOOMSLATE_SLAB = DDBlocks.register("cobbled_gloomslate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_GLOOMSLATE.get()))));
    public static final DeferredBlock<WallBlock> COBBLED_GLOOMSLATE_WALL = DDBlocks.register("cobbled_gloomslate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> POLISHED_GLOOMSLATE = DDBlocks.register("polished_gloomslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<StairBlock> POLISHED_GLOOMSLATE_STAIRS = DDBlocks.register("polished_gloomslate_stairs", () -> new StairBlock(((Block)POLISHED_GLOOMSLATE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_GLOOMSLATE.get()))));
    public static final DeferredBlock<SlabBlock> POLISHED_GLOOMSLATE_SLAB = DDBlocks.register("polished_gloomslate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_GLOOMSLATE.get()))));
    public static final DeferredBlock<WallBlock> POLISHED_GLOOMSLATE_WALL = DDBlocks.register("polished_gloomslate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_BRICKS = DDBlocks.register("gloomslate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<StairBlock> GLOOMSLATE_BRICK_STAIRS = DDBlocks.register("gloomslate_brick_stairs", () -> new StairBlock(((Block)GLOOMSLATE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE_BRICKS.get()))));
    public static final DeferredBlock<SlabBlock> GLOOMSLATE_BRICK_SLAB = DDBlocks.register("gloomslate_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE_BRICKS.get()))));
    public static final DeferredBlock<WallBlock> GLOOMSLATE_BRICK_WALL = DDBlocks.register("gloomslate_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE_BRICKS.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_TILES = DDBlocks.register("gloomslate_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<StairBlock> GLOOMSLATE_TILE_STAIRS = DDBlocks.register("gloomslate_tile_stairs", () -> new StairBlock(((Block)GLOOMSLATE_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE_TILES.get()))));
    public static final DeferredBlock<SlabBlock> GLOOMSLATE_TILE_SLAB = DDBlocks.register("gloomslate_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE_TILES.get()))));
    public static final DeferredBlock<WallBlock> GLOOMSLATE_TILE_WALL = DDBlocks.register("gloomslate_tile_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE_TILES.get()))));
    public static final DeferredBlock<Block> SMOOTH_GLOOMSLATE = DDBlocks.register("smooth_gloomslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<StairBlock> SMOOTH_GLOOMSLATE_STAIRS = DDBlocks.register("smooth_gloomslate_stairs", () -> new StairBlock(((Block)SMOOTH_GLOOMSLATE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOOTH_GLOOMSLATE.get()))));
    public static final DeferredBlock<SlabBlock> SMOOTH_GLOOMSLATE_SLAB = DDBlocks.register("smooth_gloomslate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOOTH_GLOOMSLATE.get()))));
    public static final DeferredBlock<WallBlock> SMOOTH_GLOOMSLATE_WALL = DDBlocks.register("smooth_gloomslate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOOTH_GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> CUT_GLOOMSLATE = DDBlocks.register("cut_gloomslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<StairBlock> CUT_GLOOMSLATE_STAIRS = DDBlocks.register("cut_gloomslate_stairs", () -> new StairBlock(((Block)CUT_GLOOMSLATE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_GLOOMSLATE.get()))));
    public static final DeferredBlock<SlabBlock> CUT_GLOOMSLATE_SLAB = DDBlocks.register("cut_gloomslate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_GLOOMSLATE.get()))));
    public static final DeferredBlock<WallBlock> CUT_GLOOMSLATE_WALL = DDBlocks.register("cut_gloomslate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CUT_GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> CHISELED_GLOOMSLATE = DDBlocks.register("chiseled_gloomslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMY_SCULK = DDBlocks.register("gloomy_sculk", () -> new GloomySculkBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).strength(0.3f).mapColor(MapColor.TERRACOTTA_BROWN)));
    public static final DeferredBlock<GeyserBlock> GLOOMY_GEYSER = DDBlocks.register("gloomy_geyser", () -> new GeyserBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).lightLevel(state -> 9).mapColor(MapColor.TERRACOTTA_BROWN)));
    public static final DeferredBlock<Block> CRYSTALLIZED_AMBER = DDBlocks.register("crystallized_amber", () -> new CrystallizedAmberBlock(BlockBehaviour.Properties.of().strength(0.3f, 3.0f).lightLevel(state -> 1).sound(SoundType.GLASS).mapColor(MapColor.COLOR_ORANGE).noOcclusion()));
    public static final DeferredBlock<Block> SCULK_GLEAM = DDBlocks.register("sculk_gleam", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).lightLevel(state -> 15).mapColor(MapColor.SAND)));
    public static final DeferredBlock<Block> SOUNDPROOF_GLASS = DDBlocks.register("soundproof_glass", () -> new TransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)){});
    public static final DeferredBlock<Block> SCULK_STONE_COAL_ORE = DDBlocks.register("sculk_stone_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)4), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_IRON_ORE = DDBlocks.register("sculk_stone_iron_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_COPPER_ORE = DDBlocks.register("sculk_stone_copper_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_GOLD_ORE = DDBlocks.register("sculk_stone_gold_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_REDSTONE_ORE = DDBlocks.register("sculk_stone_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get())).randomTicks().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 9 : 0)));
    public static final DeferredBlock<Block> SCULK_STONE_EMERALD_ORE = DDBlocks.register("sculk_stone_emerald_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)5, (int)10), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_LAPIS_ORE = DDBlocks.register("sculk_stone_lapis_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> SCULK_STONE_DIAMOND_ORE = DDBlocks.register("sculk_stone_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)5, (int)10), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SCULK_STONE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_COAL_ORE = DDBlocks.register("gloomslate_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)4), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_IRON_ORE = DDBlocks.register("gloomslate_iron_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_COPPER_ORE = DDBlocks.register("gloomslate_copper_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_GOLD_ORE = DDBlocks.register("gloomslate_gold_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_REDSTONE_ORE = DDBlocks.register("gloomslate_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get())).randomTicks().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 9 : 0)));
    public static final DeferredBlock<Block> GLOOMSLATE_EMERALD_ORE = DDBlocks.register("gloomslate_emerald_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)5, (int)10), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_LAPIS_ORE = DDBlocks.register("gloomslate_lapis_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOOMSLATE_DIAMOND_ORE = DDBlocks.register("gloomslate_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)5, (int)10), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOMSLATE.get()))));
    public static final DeferredBlock<Block> GLOWING_FLOWERS = DDBlocks.register("glowing_flowers", () -> new GlowingFlowersBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS).lightLevel(state -> 9).mapColor(MapColor.GLOW_LICHEN)));
    public static final DeferredBlock<Block> GLOWING_GRASS = DDBlocks.register("glowing_grass", () -> new GlowingGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).lightLevel(state -> 11).mapColor(MapColor.GLOW_LICHEN)));
    public static final DeferredBlock<Block> GLOOMY_GRASS = DDBlocks.register("gloomy_grass", () -> new GloomyGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).lightLevel(state -> 1).mapColor(MapColor.TERRACOTTA_BROWN)));
    public static final DeferredBlock<Block> GLOOMY_CACTUS = DDBlocks.register("gloomy_cactus", () -> new GloomyCactusBlock(BlockBehaviour.Properties.of().strength(0.5f).lightLevel(state -> 6).sound(SoundType.WOOL).mapColor(MapColor.COLOR_ORANGE)));
    public static final DeferredBlock<SculkTendrilsBlock> SCULK_TENDRILS = DDBlocks.register("sculk_tendrils", () -> new SculkTendrilsBlock(BlockBehaviour.Properties.of().sound(SoundType.SCULK).randomTicks().noCollission().instabreak().mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<SculkTendrilsPlantBlock> SCULK_TENDRILS_PLANT = BLOCKS.register("sculk_tendrils_plant", () -> new SculkTendrilsPlantBlock(BlockBehaviour.Properties.of().sound(SoundType.SCULK).noCollission().instabreak().mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<SculkVinesBlock> SCULK_VINES = DDBlocks.register("sculk_vines", () -> new SculkVinesBlock(BlockBehaviour.Properties.of().sound(SoundType.SCULK).randomTicks().noCollission().instabreak().mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<SculkVinesPlantBlock> SCULK_VINES_PLANT = BLOCKS.register("sculk_vines_plant", () -> new SculkVinesPlantBlock(BlockBehaviour.Properties.of().sound(SoundType.SCULK).noCollission().instabreak().mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<GlowingRootsBlock> GLOWING_ROOTS = DDBlocks.register("glowing_roots", () -> new GlowingRootsBlock(BlockBehaviour.Properties.of().sound(SoundType.CAVE_VINES).randomTicks().noCollission().instabreak().mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<GlowingRootsPlantBlock> GLOWING_ROOTS_PLANT = BLOCKS.register("glowing_roots_plant", () -> new GlowingRootsPlantBlock(BlockBehaviour.Properties.of().sound(SoundType.CAVE_VINES).noCollission().instabreak().mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<GlowingVinesBlock> GLOWING_VINES = BLOCKS.register("glowing_vines", () -> new GlowingVinesBlock(BlockBehaviour.Properties.of().sound(SoundType.CAVE_VINES).randomTicks().noCollission().instabreak().mapColor(MapColor.COLOR_LIGHT_BLUE).noLootTable()));
    public static final DeferredBlock<GlowingVinesPlantBlock> GLOWING_VINES_PLANT = BLOCKS.register("glowing_vines_plant", () -> new GlowingVinesPlantBlock(BlockBehaviour.Properties.of().lightLevel(state -> (Boolean)state.getValue((Property)GlowingVinesPlantBlock.BERRIES) != false ? 14 : 0).sound(SoundType.CAVE_VINES).noCollission().instabreak().mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<Block> ICE_LILY = BLOCKS.register("ice_lily", () -> new IceLilyBlock(BlockBehaviour.Properties.of().lightLevel(state -> 7).sound(SoundType.LILY_PAD).noOcclusion().instabreak().mapColor(MapColor.COLOR_LIGHT_BLUE).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> LILY_FLOWER = BLOCKS.register("lily_flower", () -> new LilyFlowerBlock((Holder<MobEffect>)MobEffects.GLOWING, 6.0f, BlockBehaviour.Properties.of().lightLevel(state -> 7).noCollission().instabreak().sound(SoundType.GRASS).mapColor(MapColor.PLANT).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> INFESTED_SCULK = DDBlocks.register("infested_sculk", () -> new InfestedSculkBlock(Blocks.SCULK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK)));
    public static final DeferredBlock<Block> SCULK_JAW = DDBlocks.register("sculk_jaw", () -> new SculkJawBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).randomTicks().mapColor(MapColor.COLOR_BLACK)));
    public static final DeferredBlock<Block> ANCIENT_VASE = DDBlocks.register("ancient_vase", () -> new AncientVaseBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(2.0f, 6.0f).sound((SoundType)DDSounds.VASE).mapColor(MapColor.DEEPSLATE)));
    public static final DeferredBlock<OthersidePortalBlock> OTHERSIDE_PORTAL = BLOCKS.register("otherside_portal", () -> new OthersidePortalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_PORTAL).noLootTable()));

    private static <T extends Block> DeferredBlock<T> register(String name, Supplier<T> properties) {
        DeferredBlock block = BLOCKS.register(name, properties);
        DDItems.ITEMS.registerSimpleBlockItem(name, (Supplier)block);
        return block;
    }
}

