/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;

public abstract class RegistryExportableRecipeAbstract<T extends RecipeType<? extends R>, R extends Recipe<C>, C extends RecipeInput>
implements IRegistryExportable {
    private final Supplier<T> recipeType;

    protected RegistryExportableRecipeAbstract(Supplier<T> recipeType) {
        this.recipeType = recipeType;
    }

    public T getRecipeType() {
        return (T)((RecipeType)this.recipeType.get());
    }

    @Override
    public JsonObject export() {
        JsonObject element = new JsonObject();
        JsonArray elements = new JsonArray();
        element.add("recipes", (JsonElement)elements);
        for (RecipeHolder recipeHolder : CraftingHelpers.findServerRecipes(this.getRecipeType())) {
            JsonObject serializedRecipe = this.serializeRecipe(recipeHolder);
            serializedRecipe.addProperty("id", recipeHolder.toString());
            elements.add((JsonElement)serializedRecipe);
        }
        return element;
    }

    @Override
    public String getName() {
        return BuiltInRegistries.RECIPE_TYPE.getKey(this.getRecipeType()).toString().replaceAll(":", "__");
    }

    public abstract JsonObject serializeRecipe(RecipeHolder<R> var1);
}

