/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventorySlotMasked
implements Container {
    private final Container inventory;
    private final int[] slots;

    public InventorySlotMasked(Container inventory, int ... slots) {
        this.inventory = inventory;
        this.slots = slots;
    }

    protected void validateSlot(int slot) {
        if (slot < 0 || slot >= this.getContainerSize()) {
            throw new IndexOutOfBoundsException(String.format("Tried to get slot %s from %s slots.", slot, this.getContainerSize()));
        }
    }

    protected int externalToInternalSlot(int externalSlot) {
        this.validateSlot(externalSlot);
        return this.slots[externalSlot];
    }

    public int getContainerSize() {
        return this.slots.length;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(this.externalToInternalSlot(index));
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(this.externalToInternalSlot(index), count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(this.externalToInternalSlot(index));
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(this.externalToInternalSlot(index), stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public void setChanged() {
        this.inventory.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void startOpen(Player player) {
        this.inventory.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.inventory.stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(this.externalToInternalSlot(index), stack);
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.removeItemNoUpdate(i);
        }
    }
}

