/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMap;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionEmpty;

public final class IngredientCollections {
    IngredientCollections() {
    }

    public static <T, M> IIngredientCollection<T, M> emptyCollection(IngredientComponent<T, M> ingredientComponent) {
        return new IngredientCollectionEmpty<T, M>(ingredientComponent);
    }

    public static boolean equalsOrdered(IIngredientCollection<?, ?> c1, IIngredientCollection<?, ?> c2) {
        return IngredientCollections.equalsCheckedOrdered(c1, c2);
    }

    public static <T, M> boolean equalsCheckedOrdered(IIngredientCollection<T, M> c1, IIngredientCollection<T, M> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1.getComponent() != c2.getComponent() || c1.size() != c2.size()) {
            return false;
        }
        Iterator it1 = c1.iterator();
        Iterator it2 = c2.iterator();
        IIngredientMatcher matcher = c1.getComponent().getMatcher();
        while (it1.hasNext()) {
            if (matcher.matchesExactly(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsMap(IIngredientMap<?, ?, ?> c1, IIngredientMap<?, ?, ?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1.getComponent() != c2.getComponent()) {
            return false;
        }
        return IngredientCollections.equalsMapChecked(c1, c2);
    }

    public static <T, M, V> boolean equalsMapChecked(IIngredientMap<T, M, V> c1, IIngredientMap<T, M, V> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        for (Map.Entry entry : c1) {
            if (Objects.equals(c2.get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <T, M> int hash(IIngredientCollection<T, M> collection) {
        int hash = collection.getComponent().hashCode();
        IIngredientMatcher matcher = collection.getComponent().getMatcher();
        for (Object instance : collection) {
            hash |= matcher.hash(instance);
        }
        return hash;
    }

    public static <T, M, V> int hash(IIngredientMap<T, M, V> map) {
        int hash = map.getComponent().hashCode();
        IIngredientMatcher matcher = map.getComponent().getMatcher();
        for (Map.Entry<T, V> entry : map.entrySet()) {
            hash |= matcher.hash(entry.getKey()) ^ entry.getValue().hashCode();
        }
        return hash;
    }

    public static <T, M> String toString(IIngredientCollection<T, M> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean first = true;
        for (Object instance : collection) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(instance);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static <T, M, V> String toString(IIngredientMap<T, M, V> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean first = true;
        for (Map.Entry entry : map) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("{");
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append(",");
            stringBuilder.append(entry.getValue().toString());
            stringBuilder.append("}");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static <T, M> IngredientArrayList<T, M> sort(IIngredientCollection<T, M> collection, Comparator<? super T> comparator) {
        T[] a = collection.toArray();
        Arrays.sort(a, comparator);
        return new IngredientArrayList(collection.getComponent(), a);
    }

    public static <T, M> CompoundTag serialize(HolderLookup.Provider lookupProvider, IIngredientCollection<T, M> collection) {
        CompoundTag tag = new CompoundTag();
        IngredientComponent component = collection.getComponent();
        tag.putString("component", component.getName().toString());
        ListTag list = new ListTag();
        IIngredientSerializer serializer = component.getSerializer();
        for (Object ingredient : collection) {
            list.add((Object)serializer.serializeInstance(lookupProvider, ingredient));
        }
        tag.put("ingredients", (Tag)list);
        return tag;
    }

    public static <C extends IIngredientCollectionMutable<?, ?>> C deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag, IIngredientCollectionConstructor<C> ingredientCollectionFactory) {
        IIngredientCollectionMutable collection;
        if (!tag.contains("component", 8)) {
            throw new IllegalArgumentException("No component type was found in the given tag");
        }
        if (!tag.contains("ingredients", 9)) {
            throw new IllegalArgumentException("No ingredients list was found in the given tag");
        }
        String componentTypeName = tag.getString("component");
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.get(ResourceLocation.parse((String)componentTypeName));
        if (component == null) {
            throw new IllegalArgumentException("No ingredient component with the given name was found: " + String.valueOf(component));
        }
        IIngredientSerializer serializer = component.getSerializer();
        ListTag ingredients = (ListTag)tag.get("ingredients");
        IIngredientCollectionMutable collectionUnsafe = collection = (IIngredientCollectionMutable)ingredientCollectionFactory.create(component);
        for (Tag subTag : ingredients) {
            collectionUnsafe.add(serializer.deserializeInstance(lookupProvider, subTag));
        }
        return (C)collection;
    }

    public static IngredientArrayList<?, ?> deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return IngredientCollections.deserialize(lookupProvider, tag, IngredientArrayList::new);
    }

    public static interface IIngredientCollectionConstructor<C extends IIngredientCollection<?, ?>> {
        public <T, M> C create(IngredientComponent<T, M> var1);
    }
}

