/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLikeMultiClassifiedTrait;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionSingleClassified;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;

public class IngredientCollectionMultiClassified<T, M>
extends IngredientCollectionAdapter<T, M>
implements IIngredientCollectionMutable<T, M>,
IIngredientCollectionLikeMultiClassifiedTrait<T, M, T, IngredientCollectionSingleClassified<T, M, ?, ?>> {
    private final Map<IngredientComponentCategoryType<T, M, ?>, IngredientCollectionSingleClassified<T, M, ?, ?>> classifiedCollections = Maps.newIdentityHashMap();

    public IngredientCollectionMultiClassified(IngredientComponent<T, M> component, Supplier<IIngredientCollectionMutable<T, M>> collectionCreator) {
        super(component);
        for (IngredientComponentCategoryType categoryType : component.getCategoryTypes()) {
            this.classifiedCollections.put(categoryType, new IngredientCollectionSingleClassified(component, collectionCreator, categoryType));
        }
    }

    @Override
    public boolean add(T instance) {
        boolean result = false;
        for (IngredientCollectionSingleClassified<T, M, ?, ?> singleClassified : this.classifiedCollections.values()) {
            result = singleClassified.add(instance);
        }
        return result;
    }

    public boolean addAllThreaded(@Nullable ExecutorService executorService, Iterable<? extends T> instances) {
        boolean newExecutorService = false;
        if (executorService == null) {
            executorService = Executors.newFixedThreadPool(this.classifiedCollections.size());
            newExecutorService = true;
        }
        try {
            boolean ret = (Boolean)executorService.invokeAll(this.classifiedCollections.values().stream().map(c -> () -> c.addAll(instances)).collect(Collectors.toList())).get(0).get();
            if (newExecutorService) {
                executorService.shutdown();
            }
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean remove(T instance) {
        boolean result = false;
        for (IngredientCollectionSingleClassified<T, M, ?, ?> singleClassified : this.classifiedCollections.values()) {
            result = singleClassified.remove(instance);
        }
        return result;
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        if (matchCondition.equals(this.getComponent().getMatcher().getAnyMatchCondition())) {
            int size = this.size();
            this.clear();
            return size;
        }
        IngredientCollectionSingleClassified classifiedCollection = (IngredientCollectionSingleClassified)this.getBestClassifiedCollection(matchCondition);
        Set otherClassifiedCollections = Sets.newIdentityHashSet();
        otherClassifiedCollections.addAll(this.classifiedCollections.values());
        otherClassifiedCollections.remove(classifiedCollection);
        Iterator<T> it = classifiedCollection.iterator(instance, matchCondition);
        int count = 0;
        while (it.hasNext()) {
            Object removed = it.next();
            it.remove();
            otherClassifiedCollections.forEach(c -> c.remove(removed));
            ++count;
        }
        return count;
    }

    @Override
    public boolean contains(T instance) {
        return ((IngredientCollectionSingleClassified)this.getFirstSingleClassified()).contains(instance);
    }

    @Override
    public boolean contains(T instance, M matchCondition) {
        return ((IngredientCollectionSingleClassified)this.getBestClassifiedCollection(matchCondition)).contains(instance, matchCondition);
    }

    @Override
    public int count(T instance, M matchCondition) {
        return ((IngredientCollectionSingleClassified)this.getBestClassifiedCollection(matchCondition)).count(instance, matchCondition);
    }

    @Override
    public void clear() {
        for (IngredientCollectionSingleClassified<T, M, ?, ?> singleClassified : this.classifiedCollections.values()) {
            singleClassified.clear();
        }
    }

    @Override
    public int size() {
        return ((IngredientCollectionSingleClassified)this.getFirstSingleClassified()).size();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof IngredientCollectionMultiClassified && IngredientCollections.equalsCheckedOrdered(this, (IIngredientCollection)obj);
    }

    @Override
    public Iterator<T> iterator() {
        return new IIngredientCollectionLikeMultiClassifiedTrait.RemoveCallbackIterator(this, null, this.getComponent().getMatcher().getAnyMatchCondition());
    }

    @Override
    public Iterator<T> iterator(T instance, M matchCondition) {
        return new IIngredientCollectionLikeMultiClassifiedTrait.RemoveCallbackIterator(this, instance, matchCondition);
    }

    @Override
    public void removeInstance(IngredientCollectionSingleClassified<T, M, ?, ?> collection, T iterableInstance) {
        collection.remove(iterableInstance);
    }

    @Override
    public Map<IngredientComponentCategoryType<T, M, ?>, IngredientCollectionSingleClassified<T, M, ?, ?>> getClassifiedCollections() {
        return this.classifiedCollections;
    }
}

