/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class CraftingRecipeAppendix
extends RecipeAppendix<CraftingRecipe> {
    private static final int SLOT_OFFSET_X = 5;
    private static final int SLOT_OFFSET_Y = 5;
    private static final int START_X_RESULT = 84;
    private static final AdvancedButtonEnum[] INPUT = new AdvancedButtonEnum[9];
    private static final AdvancedButtonEnum RESULT;

    public CraftingRecipeAppendix(IInfoBook infoBook, RecipeHolder<? extends CraftingRecipe> recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 104;
    }

    @Override
    protected int getHeightInner() {
        return 58;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "block.minecraft.crafting_table";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        for (int i = 0; i < 9; ++i) {
            this.renderItemHolders.put(INPUT[i], new RecipeAppendix.ItemButton(this.getInfoBook()));
        }
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int j;
        int i;
        gui.drawArrowRight(guiGraphics, x + 63 - 3, y + 5 + 16 + 2);
        int tick = this.getTick(gui);
        ItemStack[] grid = new ItemStack[9];
        ItemStack result = this.prepareItemStack(((CraftingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().player.level().registryAccess()), tick);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                grid[i + j * 3] = this.prepareItemStacks(Lists.newArrayList((Object[])this.getItemStacks(i + j * 3).getItems()), tick);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.renderItem(gui, guiGraphics, x + 21 * i, y + 21 * j, grid[i + j * 3], mx, my, INPUT[i + j * 3]);
            }
        }
        this.renderItem(gui, guiGraphics, x + 84, y + 21, result, mx, my, RESULT);
        this.renderItem(gui, guiGraphics, x + 63, y + 5 + 16, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), mx, my, false, null);
    }

    private static NonNullList<Ingredient> formatShapedGrid(NonNullList<Ingredient> itemStacksRaw, int width, int height) {
        int rawIndex = 0;
        NonNullList itemStacks = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                itemStacks.set(y * 3 + x, (Object)((Ingredient)itemStacksRaw.get(rawIndex++)));
                if (rawIndex >= itemStacksRaw.size()) break;
            }
            if (rawIndex >= itemStacksRaw.size()) break;
        }
        return itemStacks;
    }

    protected Ingredient getItemStacks(int index) {
        NonNullList<Ingredient> ingredients = this.recipe.value() instanceof ShapedRecipe ? CraftingRecipeAppendix.formatShapedGrid((NonNullList<Ingredient>)((CraftingRecipe)this.recipe.value()).getIngredients(), ((ShapedRecipe)this.recipe.value()).getWidth(), ((ShapedRecipe)this.recipe.value()).getHeight()) : ((CraftingRecipe)this.recipe.value()).getIngredients();
        if (ingredients.size() <= index) {
            return Ingredient.EMPTY;
        }
        return (Ingredient)ingredients.get(index);
    }

    static {
        for (int i = 0; i < 9; ++i) {
            CraftingRecipeAppendix.INPUT[i] = AdvancedButtonEnum.create();
        }
        RESULT = AdvancedButtonEnum.create();
    }
}

