/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.command.CommandConfig;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.CreativeModeTabConfigCommon;
import org.cyclops.cyclopscore.helper.LoggerHelper;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.RegistryManager;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxyCommon;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;

public abstract class ModBaseCommon<T extends ModBaseCommon<T>>
implements IModBase {
    private static final Map<String, ModBaseCommon<?>> MOD_BASES = Maps.newConcurrentMap();
    private final String modId;
    private final LoggerHelper loggerHelper;
    private final RegistryManager registryManager;
    private final ModCompatLoader modCompatLoader;
    @Nullable
    private CreativeModeTab defaultCreativeTab = null;
    private final List<Pair<ItemStack, CreativeModeTab.TabVisibility>> defaultCreativeTabEntries = Lists.newArrayList();

    public ModBaseCommon(String modId, Consumer<T> instanceSetter) {
        instanceSetter.accept(this);
        MOD_BASES.put(modId, this);
        this.modId = modId;
        this.loggerHelper = this.constructLoggerHelper();
        this.registryManager = this.constructRegistryManager();
        this.modCompatLoader = this.constructModCompatLoader();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public LoggerHelper getLoggerHelper() {
        return this.loggerHelper;
    }

    protected LoggerHelper constructLoggerHelper() {
        return new LoggerHelper(this.getModId());
    }

    protected RegistryManager constructRegistryManager() {
        return new RegistryManager();
    }

    @Override
    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    protected abstract IClientProxyCommon constructClientProxy();

    protected abstract ICommonProxyCommon constructCommonProxy();

    @Override
    public ModCompatLoader getModCompatLoader() {
        return this.modCompatLoader;
    }

    protected ModCompatLoader constructModCompatLoader() {
        return new ModCompatLoader(this);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand(Commands.CommandSelection selection, CommandBuildContext context) {
        LiteralArgumentBuilder root = Commands.literal((String)this.getModId());
        root.then(CommandConfig.make(this));
        return root;
    }

    @Override
    @Nullable
    public CreativeModeTab getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    @Override
    public List<Pair<ItemStack, CreativeModeTab.TabVisibility>> getDefaultCreativeTabEntries() {
        return this.defaultCreativeTabEntries;
    }

    @Override
    public void registerDefaultCreativeTabEntry(ItemStack itemStack, CreativeModeTab.TabVisibility visibility) {
        if (this.defaultCreativeTabEntries == null) {
            throw new IllegalStateException("Tried to register default tab entries after the CreativeModeTabEvent.BuildContents event");
        }
        if (itemStack.getCount() != 1) {
            throw new IllegalStateException("Tried to register default tab entries with a non-1-count ItemStack");
        }
        this.defaultCreativeTabEntries.add((Pair<ItemStack, CreativeModeTab.TabVisibility>)Pair.of((Object)itemStack, (Object)visibility));
    }

    protected CreativeModeTabConfigCommon<ModBaseCommon<T>> constructDefaultCreativeModeTabConfig() {
        return new CreativeModeTabConfigCommon<ModBaseCommon<T>>(this, "default", config -> {
            this.defaultCreativeTab = this.constructDefaultCreativeModeTab(CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0)).build();
            return this.defaultCreativeTab;
        });
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return builder.title((Component)Component.translatable((String)("itemGroup." + this.getModId()))).icon(() -> new ItemStack((ItemLike)Items.BARRIER)).displayItems((parameters, output) -> {
            for (Pair<ItemStack, CreativeModeTab.TabVisibility> entry : this.defaultCreativeTabEntries) {
                output.accept((ItemStack)entry.getLeft(), (CreativeModeTab.TabVisibility)entry.getRight());
            }
        });
    }

    protected boolean hasDefaultCreativeModeTab() {
        return true;
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        if (this.hasDefaultCreativeModeTab()) {
            this.getConfigHandler().addConfigurable(this.constructDefaultCreativeModeTabConfig());
        }
    }

    public String toString() {
        return this.getModId();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    @Nullable
    public static ModBaseCommon getCommon(String modId) {
        return MOD_BASES.get(modId);
    }

    public static Map<String, ModBaseCommon<?>> getCommonMods() {
        return MOD_BASES;
    }
}

