/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.PacketCodecException;

public abstract class PacketBase<T extends PacketBase<T>>
implements CustomPacketPayload {
    private final CustomPacketPayload.Type<T> type;

    protected PacketBase(CustomPacketPayload.Type<T> type) {
        this.type = type;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return this.type;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        try {
            this.encode(buf);
        }
        catch (Throwable e) {
            throw new PacketCodecException("An exception occurred during encoding of packet " + this.toString(), e);
        }
    }

    public abstract boolean isAsync();

    public abstract void encode(RegistryFriendlyByteBuf var1);

    public abstract void decode(RegistryFriendlyByteBuf var1);

    public abstract void actionClient(Level var1, Player var2);

    public abstract void actionServer(Level var1, ServerPlayer var2);

    public static <T extends PacketBase<T>> StreamCodec<RegistryFriendlyByteBuf, T> getCodec(Supplier<T> packetFactory) {
        return StreamCodec.ofMember(PacketBase::write, buff -> {
            PacketBase payload = (PacketBase)packetFactory.get();
            try {
                payload.decode((RegistryFriendlyByteBuf)buff);
            }
            catch (Throwable e) {
                throw new PacketCodecException("An exception occurred during decoding of packet " + payload.toString(), e);
            }
            return payload;
        });
    }
}

