/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public interface INbtPathExpression {
    default public NbtPathExpressionMatches match(Stream<Tag> nbts) {
        return this.matchContexts(nbts.map(NbtPathExpressionExecutionContext::new));
    }

    default public NbtPathExpressionMatches match(Tag nbt) {
        return this.match(Stream.of(nbt));
    }

    default public boolean test(Stream<Tag> nbts) {
        return this.match(nbts.limit(1L)).getMatches().findAny().filter(tag -> tag.getId() != 1 || ((ByteTag)tag).getAsByte() == 1).isPresent();
    }

    default public boolean test(Tag nbt) {
        return this.test(Stream.of(nbt));
    }

    public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> var1);

    default public INbtPathNavigation asNavigation(@Nullable INbtPathNavigation child) throws NbtParseException {
        throw new NbtParseException("This NBT Path expression has no navigation keys.");
    }

    default public INbtPathNavigation asNavigation() throws NbtParseException {
        return this.asNavigation(null);
    }
}

