/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementButton
extends AdvancedButton {
    private final ResourceLocation advancementId;

    public AdvancementButton(ResourceLocation advancementId) {
        this.advancementId = advancementId;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
        super.renderTooltip(guiGraphics, font, mx, my);
        guiGraphics.pose().pushPose();
        if (mx >= this.getX() && my >= this.getY() && mx <= this.getX() + 16 && my <= this.getY() + 16) {
            ArrayList lines = Lists.newArrayList();
            AdvancementHolder advancement = AdvancementHelpers.getAdvancement(Dist.CLIENT, this.advancementId);
            if (advancement != null) {
                advancement.value().display().ifPresent(display -> {
                    lines.add(display.getTitle().getVisualOrderText());
                    lines.add(display.getDescription().getVisualOrderText());
                });
            }
            guiGraphics.renderTooltip(font, (List)lines, mx, my);
        }
        guiGraphics.pose().popPose();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }
}

