/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import java.util.List;
import nanonestor.cursedearth.BlessedEarthBlock;
import nanonestor.cursedearth.CursedEarth;
import nanonestor.cursedearth.CursedEarthBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class MessageSpawns {
    @SubscribeEvent
    public void whatthat(PlayerInteractEvent.RightClickBlock e) {
        Player player = e.getEntity();
        BlockPos pos = e.getPos();
        Level level = e.getLevel();
        Block block = level.getBlockState(pos).getBlock();
        if (!(block instanceof CursedEarthBlock) && !(block instanceof BlessedEarthBlock)) {
            return;
        }
        MutableComponent names = Component.literal((String)"");
        if (!level.isClientSide && e.getHand() == InteractionHand.MAIN_HAND && player.getMainHandItem().isEmpty() && player.isShiftKeyDown()) {
            MutableComponent this_name;
            MobSpawnSettings.SpawnerData spawners2;
            int i;
            List<MobSpawnSettings.SpawnerData> entries;
            ServerChunkCache s;
            if (block instanceof CursedEarthBlock) {
                s = (ServerChunkCache)level.getChunkSource();
                entries = s.getGenerator().getMobsAt(level.getBiome(pos), ((ServerLevel)level).structureManager(), MobCategory.MONSTER, pos.above()).unwrap().stream().filter(spawners -> !spawners.type.is(CursedEarth.blacklisted_entities)).toList();
                if (entries.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.cursedearth.nospawns").withStyle(ChatFormatting.GOLD), true);
                } else {
                    names.append((Component)Component.literal((String)"Cursed Earth Spawning Mobs: ").withStyle(ChatFormatting.DARK_PURPLE));
                    for (i = 0; i < entries.size(); ++i) {
                        spawners2 = entries.get(i);
                        this_name = (MutableComponent)spawners2.type.getDescription();
                        names.append((Component)this_name.withStyle(ChatFormatting.GOLD));
                        if (i >= entries.size() - 1) continue;
                        names.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.AQUA));
                    }
                    player.displayClientMessage((Component)names, false);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ASH, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 60, 0.5, 1.2, 0.5, 0.05);
                    }
                }
            }
            if (block instanceof BlessedEarthBlock) {
                s = (ServerChunkCache)level.getChunkSource();
                entries = s.getGenerator().getMobsAt(level.getBiome(pos), ((ServerLevel)level).structureManager(), MobCategory.CREATURE, pos.above()).unwrap().stream().filter(spawners -> !spawners.type.is(CursedEarth.blacklisted_entities)).toList();
                if (entries.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.cursedearth.nospawns").withStyle(ChatFormatting.GOLD), true);
                } else {
                    names.append((Component)Component.literal((String)"Blessed Earth Spawning Mobs: ").withStyle(ChatFormatting.DARK_AQUA));
                    for (i = 0; i < entries.size(); ++i) {
                        spawners2 = entries.get(i);
                        this_name = (MutableComponent)spawners2.type.getDescription();
                        names.append((Component)this_name.withStyle(ChatFormatting.GOLD));
                        if (i >= entries.size() - 1) continue;
                        names.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.WHITE));
                    }
                    player.displayClientMessage((Component)names, false);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.OMINOUS_SPAWNING, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 60, 0.5, 1.2, 0.5, 0.05);
                    }
                }
            }
        }
    }
}

