/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CursedEarthConfig {
    public static final ModConfigSpec GENERAL_SPEC;
    public static final General GENERAL;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(General::new);
        GENERAL = (General)specPair.getLeft();
        GENERAL_SPEC = (ModConfigSpec)specPair.getRight();
        Pair specPair1 = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)specPair1.getLeft();
        CLIENT_SPEC = (ModConfigSpec)specPair1.getRight();
    }

    public static class General {
        public final ModConfigSpec.IntValue minTickTime;
        public final ModConfigSpec.IntValue maxTickTime;
        public final ModConfigSpec.IntValue burnLightLevel;
        public final ModConfigSpec.BooleanValue forceSpawn;
        public final ModConfigSpec.BooleanValue diesFromLightLevel;
        public final ModConfigSpec.BooleanValue naturallySpreads;
        public final ModConfigSpec.IntValue spawnRadius;
        public final ModConfigSpec.BooleanValue doItemsMakeEarth;
        public final ModConfigSpec.ConfigValue<String> cursedItem;
        public final ModConfigSpec.ConfigValue<String> blessedItem;

        public General(ModConfigSpec.Builder builder) {
            builder.push("General");
            this.minTickTime = builder.comment("minimum time between spawns in ticks").defineInRange("min tick time", 100, 1, Integer.MAX_VALUE);
            this.maxTickTime = builder.comment("maximum time between spawns in ticks").defineInRange("max tick time", 600, 1, Integer.MAX_VALUE);
            this.burnLightLevel = builder.comment("the light level above which cursed earth blocks burn - default 7 - allowed values 1 to 15").defineInRange("burn light level", 7, 1, 15);
            this.forceSpawn = builder.comment("Force spawns to occur regardless of conditions such as light level and elevation").define("force spawns", false);
            this.diesFromLightLevel = builder.comment("does cursed earth die from light levels").define("dies from light level", true);
            this.naturallySpreads = builder.comment("does cursed earth naturally spread").define("naturally spreads", true);
            this.doItemsMakeEarth = builder.comment("do the items set as 'cursed item' and 'blessed item' make earths - set false to disable").define("do items make earth", true);
            this.spawnRadius = builder.comment("minimum distance cursed earth has to be away from players before it spawns mobs").defineInRange("spawn radius", 1, 1, Integer.MAX_VALUE);
            this.cursedItem = builder.comment("item used to create cursed earth").define("cursed item", (Object)BuiltInRegistries.ITEM.getKey((Object)Items.WITHER_ROSE).toString());
            this.blessedItem = builder.comment("item used to create blessed earth").define("blessed item", (Object)"cursedearth:blessed_flower", o -> o instanceof String);
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<String> color_cursed_earth;
        public final ModConfigSpec.ConfigValue<String> color_blessed_earth;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("Client");
            this.color_cursed_earth = builder.comment("Color of cursed earth, pick #CC00FF classic style color, pick #222222 for brighter newage color, or any hex code color you would like.").define("color_cursed_earth", (Object)"#CC00FF", String.class::isInstance);
            this.color_blessed_earth = builder.comment("Color of blessed earth, default value is #00BCD4").define("color_blessed_earth", (Object)"#00BCD4", String.class::isInstance);
            builder.pop();
        }
    }
}

