/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import nanonestor.cursedearth.BlessedEarthBlock;
import nanonestor.cursedearth.BlessedFlowerBlock;
import nanonestor.cursedearth.CursedEarthBlock;
import nanonestor.cursedearth.CursedEarthConfig;
import nanonestor.cursedearth.MessageSpawns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="cursedearth")
public class CursedEarth {
    public static final String MODID = "cursedearth";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"cursedearth");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("cursed_earth", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).title(Component.nullToEmpty((String)"Cursed Earth")).icon(() -> CursedEarthBlock.cursed_earth_item.getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept(CursedEarthBlock.cursed_earth_item.getDefaultInstance());
        output.accept(BlessedEarthBlock.blessed_earth_item.getDefaultInstance());
        output.accept(BlessedFlowerBlock.blessed_flower_item.getDefaultInstance());
    }).build());
    public static final TagKey<EntityType<?>> blacklisted_entities = CursedEarth.create(ResourceLocation.fromNamespaceAndPath((String)"cursedearth", (String)"blacklisted"));
    public static final TagKey<Block> spreadable = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cursedearth", (String)"spreadable"));

    private static TagKey<EntityType<?>> create(ResourceLocation p_203849_) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)p_203849_);
    }

    public CursedEarth(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CursedEarthConfig.GENERAL_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CursedEarthConfig.CLIENT_SPEC);
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(this::onClientSetup);
        }
        modEventBus.addListener(this::blocks);
        NeoForge.EVENT_BUS.addListener(this::rose);
        NeoForge.EVENT_BUS.register((Object)new MessageSpawns());
        CREATIVE_MODE_TABS.register(modEventBus);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)CursedEarthBlock.cursed_earth, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)BlessedEarthBlock.blessed_earth, (RenderType)RenderType.cutout());
    }

    public void blocks(RegisterEvent event) {
        event.register(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"cursed_earth"), () -> CursedEarthBlock.cursed_earth);
        event.register(Registries.ITEM, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"cursed_earth"), () -> CursedEarthBlock.cursed_earth_item);
        event.register(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"blessed_earth"), () -> BlessedEarthBlock.blessed_earth);
        event.register(Registries.ITEM, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"blessed_earth"), () -> BlessedEarthBlock.blessed_earth_item);
        event.register(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"blessed_flower"), () -> BlessedFlowerBlock.blessed_flower);
        event.register(Registries.ITEM, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"blessed_flower"), () -> BlessedFlowerBlock.blessed_flower_item);
    }

    private void rose(PlayerInteractEvent.RightClickBlock e) {
        if (!((Boolean)CursedEarthConfig.GENERAL.doItemsMakeEarth.get()).booleanValue()) {
            return;
        }
        Player p = e.getEntity();
        Level w = p.level();
        BlockPos pos = e.getPos();
        boolean isBlockSpreadable = w.getBlockState(pos).is(spreadable);
        if (p.isShiftKeyDown() && !w.isClientSide() && e.getItemStack().getItem() == BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)((String)CursedEarthConfig.GENERAL.cursedItem.get()))) && isBlockSpreadable) {
            w.setBlockAndUpdate(pos, CursedEarthBlock.cursed_earth.defaultBlockState());
            p.getItemInHand(p.getUsedItemHand()).shrink(1);
            e.setCanceled(true);
        }
        if (p.isShiftKeyDown() && !w.isClientSide() && e.getItemStack().getItem() == BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)((String)CursedEarthConfig.GENERAL.blessedItem.get()))) && isBlockSpreadable) {
            w.setBlockAndUpdate(pos, BlessedEarthBlock.blessed_earth.defaultBlockState());
            p.getItemInHand(p.getUsedItemHand()).shrink(1);
            e.setCanceled(true);
        }
    }

    @EventBusSubscriber(modid="cursedearth", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Colors {
        @SubscribeEvent
        public static void color(FMLClientSetupEvent e) {
            BlockColors blockColors = Minecraft.getInstance().getBlockColors();
            BlockColor iBlockColor = (blockState, iEnviromentBlockReader, blockPos, i) -> Integer.decode((String)CursedEarthConfig.CLIENT.color_cursed_earth.get());
            BlockColor jBlockColor = (blockState, iEnviromentBlockReader, blockPos, i) -> Integer.decode((String)CursedEarthConfig.CLIENT.color_blessed_earth.get());
            blockColors.register(iBlockColor, new Block[]{CursedEarthBlock.cursed_earth});
            blockColors.register(jBlockColor, new Block[]{BlessedEarthBlock.blessed_earth});
            ItemColors cursed_itemColors = Minecraft.getInstance().getItemColors();
            ItemColors blessed_itemColors = Minecraft.getInstance().getItemColors();
            ItemColor cursed_itemBlockColor = (stack, tintIndex) -> {
                BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
                return blockColors.getColor(state, null, null, tintIndex);
            };
            ItemColor blessed_itemBlockColor = (stack, tintIndex) -> {
                BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
                return blockColors.getColor(state, null, null, tintIndex);
            };
            cursed_itemColors.register(cursed_itemBlockColor, new ItemLike[]{CursedEarthBlock.cursed_earth});
            blessed_itemColors.register(blessed_itemBlockColor, new ItemLike[]{BlessedEarthBlock.blessed_earth});
        }
    }
}

