/*
 * Decompiled with CFR 0.152.
 */
package nanonestor.cursedearth;

import java.util.List;
import nanonestor.cursedearth.CursedEarth;
import nanonestor.cursedearth.CursedEarthBlock;
import nanonestor.cursedearth.CursedEarthConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BlessedEarthBlock
extends GrassBlock {
    public static final Block blessed_earth = new BlessedEarthBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK));
    public static final Item blessed_earth_item = new BlockItem(blessed_earth, new Item.Properties());

    public BlessedEarthBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        this.schedule(pos, world);
    }

    public void schedule(BlockPos pos, Level level) {
        int maxTime = 5 * (Integer)CursedEarthConfig.GENERAL.maxTickTime.get();
        int minTime = 3 * (Integer)CursedEarthConfig.GENERAL.minTickTime.get();
        level.scheduleTick(pos, (Block)this, level.random.nextInt(maxTime - minTime));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            boolean dark;
            this.schedule(pos, (Level)level);
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            boolean bl = dark = level.getMaxLocalRawBrightness(pos.above()) <= 7;
            if (dark) {
                level.setBlockAndUpdate(pos, CursedEarthBlock.cursed_earth.defaultBlockState());
            } else if (!dark && ((Boolean)CursedEarthConfig.GENERAL.naturallySpreads.get()).booleanValue() && level.getBlockState(pos.above()).isAir()) {
                BlockState blockstate = this.defaultBlockState();
                for (int i = 0; i < 4; ++i) {
                    BlockPos pos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (!level.getBlockState(pos1).is(CursedEarth.spreadable) || !level.getBlockState(pos1.above()).isAir()) continue;
                    level.setBlockAndUpdate(pos1, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(pos1.above()).getBlock() == Blocks.SNOW)));
                }
            }
            if (!level.getFluidState(pos.above()).isEmpty()) {
                return;
            }
            if (level.getLevelData().getDifficulty() == Difficulty.PEACEFUL) {
                return;
            }
            if (!dark) {
                int r = (Integer)CursedEarthConfig.GENERAL.spawnRadius.get();
                if (level.getEntitiesOfClass(Player.class, new AABB((double)(-r), (double)(-r), (double)(-r), (double)r, (double)r, (double)r)).size() > 0) {
                    return;
                }
                Entity en2 = this.findMobToSpawn(level, pos.above(), random);
                if (en2 != null) {
                    en2.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
                    if (!level.noCollision(en2) || !level.isUnobstructed(en2)) {
                        return;
                    }
                    level.addFreshEntity(en2);
                }
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state, boolean p_176473_4_) {
        return false;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    private Entity findMobToSpawn(ServerLevel level, BlockPos pos, RandomSource rand) {
        ServerChunkCache s = level.getChunkSource();
        List<MobSpawnSettings.SpawnerData> spawnOptions = s.getGenerator().getMobsAt(level.getBiome(pos), level.structureManager(), MobCategory.CREATURE, pos).unwrap().stream().filter(spawners -> !spawners.type.is(CursedEarth.blacklisted_entities)).toList();
        if (spawnOptions.isEmpty()) {
            return null;
        }
        int found = rand.nextInt(spawnOptions.size());
        MobSpawnSettings.SpawnerData entry = spawnOptions.get(found);
        EntityType type = entry.type;
        Entity ent = type.create((Level)level);
        if (ent instanceof Mob) {
            ((Mob)ent).finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
        }
        return ent;
    }
}

