/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ArmorStandCuriosDisplayLayer<ENTITY extends LivingEntity, MODEL extends EntityModel<ENTITY>>
extends RenderLayer<ENTITY, MODEL> {
    public ArmorStandCuriosDisplayLayer(RenderLayerParent<ENTITY, MODEL> renderer) {
        super(renderer);
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, @Nonnull ENTITY entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
        EntityHitResult hitResult;
        HitResult hitResult2 = Minecraft.getInstance().hitResult;
        if (hitResult2 instanceof EntityHitResult && (hitResult = (EntityHitResult)hitResult2).getEntity() == entity) {
            CuriosApi.getCuriosInventory(entity).map(ICuriosItemHandler::getCurios).map(curios -> (ICurioStacksHandler)curios.get("curio")).map(ICurioStacksHandler::getCosmeticStacks).ifPresent(cosmetics -> {
                int slot;
                int itemCount = 0;
                for (slot = 0; slot < cosmetics.getSlots(); ++slot) {
                    if (cosmetics.getStackInSlot(slot).isEmpty()) continue;
                    ++itemCount;
                }
                poseStack.pushPose();
                poseStack.scale(0.25f, 0.25f, 0.25f);
                poseStack.translate((float)(itemCount - 1) / 2.0f, -4.0f, 0.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                for (slot = cosmetics.getSlots() - 1; slot >= 0; --slot) {
                    ItemStack item = cosmetics.getStackInSlot(slot);
                    if (item.isEmpty()) continue;
                    Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, poseStack, buffer, null, 0);
                    poseStack.translate(1.0f, 0.0f, 0.0f);
                }
                poseStack.popPose();
            });
        }
    }
}

