/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.data;

import com.tom.stockbridge.StockBridge;
import com.tom.stockbridge.client.ClientRegistration;
import com.tom.stockbridge.data.SBRecipes;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="createstockbridge", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherDataLang(GatherDataEvent event) {
        if (event.getMods().contains("createstockbridge")) {
            StockBridge.registrate().addDataGenerator(ProviderType.LANG, provider -> {
                BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
                DataGenerators.providePonderLang(langConsumer);
            });
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        ClientRegistration.register();
        PonderIndex.getLangAccess().provideLang("createstockbridge", consumer);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (!event.getMods().contains("createstockbridge")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new SBRecipes(packOutput, lookupProvider));
    }
}

