/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tom.stockbridge.Registration;
import com.tom.stockbridge.ae.AERegistration;
import com.tom.stockbridge.ae.AERemoteItemKey;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VirtualPattern
implements IPatternDetails {
    private static final LoadingCache<AEItemKey, VirtualPattern> PATTERN_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(VirtualPattern::new));
    private final IPatternDetails.IInput[] input;
    private final List<GenericStack> output;
    private final AEItemKey item;
    private final AEItemKey result;

    private VirtualPattern(AEItemKey result) {
        this.result = result;
        this.output = List.of(new GenericStack((AEKey)result, 1L));
        this.input = new IPatternDetails.IInput[]{new Input(result)};
        ItemStack stack = Registration.REQUEST_ITEM.asStack();
        stack.set(AERegistration.VIRTUAL_PATTERN_OUT, (Object)result);
        this.item = AEItemKey.of((ItemStack)stack);
    }

    public static VirtualPattern of(AEItemKey result) {
        try {
            return (VirtualPattern)PATTERN_CACHE.get((Object)result);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public AEItemKey getDefinition() {
        return this.item;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.input;
    }

    public List<GenericStack> getOutputs() {
        return this.output;
    }

    public AEItemKey getResult() {
        return this.result;
    }

    private static class Input
    implements IPatternDetails.IInput {
        private GenericStack[] template;

        public Input(AEItemKey item) {
            this.template = new GenericStack[]{new GenericStack((AEKey)AERemoteItemKey.of(item.getReadOnlyStack()), 1L)};
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level p1) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey p0) {
            return null;
        }
    }
}

