/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.helpers.IPriorityHost;
import appeng.helpers.MultiCraftingTracker;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.helpers.MachineSource;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import com.google.common.collect.ImmutableSet;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.tom.stockbridge.ae.AERegistration;
import com.tom.stockbridge.ae.AERemoteItemKey;
import com.tom.stockbridge.ae.RemoteItemKeyType;
import com.tom.stockbridge.ae.VirtualPattern;
import com.tom.stockbridge.ae.menu.AEStockBridgeMenu;
import com.tom.stockbridge.block.entity.AbstractStockBridgeBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractAEStockBridgeBlockEntity
extends AbstractStockBridgeBlockEntity
implements IGridConnectedBlockEntity,
IPriorityHost,
IStorageProvider,
ICraftingProvider,
ICraftingRequester {
    protected final IManagedGridNode mainNode;
    protected final MEStorage inventory;
    private int priority = 100;
    private boolean wasOnline;
    private boolean setChangedQueued;
    protected MultiCraftingTracker craftingTracker;
    protected InventorySummary items;
    protected final IActionSource actionSource;
    private KeyCounter itemRequests = new KeyCounter();

    public AbstractAEStockBridgeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.mainNode = this.createMainNode().setVisualRepresentation((ItemLike)AERegistration.BRIDGE_BLOCK.asItem()).setInWorldNode(true).setTagName("proxy").setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(4.0);
        this.inventory = new BridgeStorge();
        this.craftingTracker = new MultiCraftingTracker((ICraftingRequester)this, 8);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this);
        this.getMainNode().addService(ICraftingRequester.class, (IGridNodeService)this);
        this.getMainNode().addService(ICraftingProvider.class, (IGridNodeService)this);
        this.actionSource = new MachineSource(() -> ((IManagedGridNode)this.mainNode).getNode());
        this.onGridConnectableSidesChanged();
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (!clientPacket) {
            this.getMainNode().saveToNBT(tag);
            tag.putInt("priority", this.getPriority());
            this.craftingTracker.writeToNBT(tag);
            ListTag list = new ListTag();
            for (Object2LongMap.Entry input : this.itemRequests) {
                CompoundTag t = ((AEKey)input.getKey()).toTagGeneric(registries);
                t.putLong("cnt", input.getLongValue());
                list.add((Object)t);
            }
            tag.put("requests", (Tag)list);
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (!clientPacket) {
            this.getMainNode().loadFromNBT(tag);
            this.priority = tag.getInt("priority");
            this.craftingTracker.readFromNBT(tag);
            this.itemRequests.clear();
            ListTag list = tag.getList("requests", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag t = list.getCompound(i);
                AEKey key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)t);
                long value = t.getLong("cnt");
                this.itemRequests.add(key, value);
            }
        }
    }

    public final IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getMainNode().destroy();
    }

    public void onReady() {
        this.getMainNode().create(this.getLevel(), this.getBlockPos());
    }

    protected final void onGridConnectableSidesChanged() {
        this.getMainNode().setExposedOnSides(this.getGridConnectableSides(null));
    }

    public void invalidate() {
        super.invalidate();
        this.getMainNode().destroy();
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.scheduleInit();
    }

    public void saveChanges() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            this.setChanged();
        } else {
            this.level.blockEntityChanged(this.worldPosition);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable((LevelAccessor)null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    protected void scheduleInit() {
        GridHelper.onFirstTick((BlockEntity)this, AbstractAEStockBridgeBlockEntity::onReady);
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.setChanged();
        this.setChangedQueued = false;
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getPatternPriority() {
        return this.getPriority();
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.setChanged();
        this.remountStorage();
    }

    private void remountStorage() {
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.remountStorage();
            this.setChanged();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide && this.level.getGameTime() % 20L == (long)(Math.abs(this.worldPosition.hashCode()) % 20)) {
            this.items = this.behaviour.getItems();
            this.remountStorage();
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            for (Object2LongMap.Entry input : this.itemRequests) {
                int req = this.behaviour.requestItem(((AEItemKey)input.getKey()).toStack(), (int)input.getLongValue());
                toRemove.add(Pair.of((Object)((AEKey)input.getKey()), (Object)req));
            }
            toRemove.forEach(p -> this.itemRequests.remove((AEKey)p.getFirst(), (long)((Integer)p.getSecond()).intValue()));
            if (!toRemove.isEmpty()) {
                this.sendPulseNextSync();
                this.notifyUpdate();
            }
            this.itemRequests.removeZeros();
        }
    }

    public void mountInventories(IStorageMounts mounts) {
        if (this.getMainNode().isOnline()) {
            mounts.mount(this.inventory, this.priority);
        }
    }

    public ItemStack getMainMenuIcon() {
        return AERegistration.BRIDGE_BLOCK.asStack();
    }

    public void returnToMainMenu(Player player, ISubMenu arg1) {
        MenuOpener.returnTo(AEStockBridgeMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public void openConfigMenu(Player player) {
        MenuOpener.open(AEStockBridgeMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    @Override
    public InventorySummary fetchSummaryFromPackager() {
        if (this.getPackager() == null) {
            return InventorySummary.EMPTY;
        }
        InventorySummary sum = new InventorySummary();
        this.mainNode.getGrid().getStorageService().getCachedInventory().forEach(e -> {
            AEKey item = (AEKey)e.getKey();
            long amount = e.getLongValue();
            if (item instanceof AEItemKey) {
                AEItemKey i = (AEItemKey)item;
                sum.add(i.toStack(), (int)amount);
            } else if (item instanceof AERemoteItemKey) {
                AERemoteItemKey aERemoteItemKey = (AERemoteItemKey)item;
            }
        });
        return sum;
    }

    public List<IPatternDetails> getAvailablePatterns() {
        if (this.items != null) {
            ArrayList<IPatternDetails> l = new ArrayList<IPatternDetails>();
            for (BigItemStack item : this.items.getStacks()) {
                if (item.stack.isEmpty()) continue;
                l.add(VirtualPattern.of(AEItemKey.of((ItemStack)item.stack)));
            }
            return l;
        }
        return List.of();
    }

    public boolean pushPattern(IPatternDetails pattern, KeyCounter[] items) {
        if (pattern instanceof VirtualPattern) {
            VirtualPattern p = (VirtualPattern)pattern;
            long cnt = 0L;
            for (KeyCounter keyCounter : items) {
                for (Object2LongMap.Entry input : keyCounter) {
                    cnt += input.getLongValue();
                }
            }
            this.itemRequests.add((AEKey)p.getResult(), cnt);
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return false;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    private class BridgeStorge
    implements MEStorage {
        private BridgeStorge() {
        }

        public Component getDescription() {
            return AERegistration.BRIDGE_BLOCK.asItem().getDescription();
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (AbstractAEStockBridgeBlockEntity.this.items != null && what instanceof AERemoteItemKey) {
                AERemoteItemKey is = (AERemoteItemKey)what;
                int count = AbstractAEStockBridgeBlockEntity.this.items.getCountOf(is.getReadOnlyStack());
                long max = Math.min((long)count, amount);
                if (mode == Actionable.MODULATE) {
                    AbstractAEStockBridgeBlockEntity.this.items.erase(is.toStack((int)max));
                }
                return max;
            }
            return 0L;
        }

        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            return what.getType() == RemoteItemKeyType.INSTANCE ? amount : 0L;
        }

        public void getAvailableStacks(KeyCounter out) {
            if (AbstractAEStockBridgeBlockEntity.this.items != null) {
                for (BigItemStack item : AbstractAEStockBridgeBlockEntity.this.items.getStacks()) {
                    if (item.stack.isEmpty()) continue;
                    out.add((AEKey)AERemoteItemKey.of(item.stack), (long)item.count);
                }
            }
        }

        public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
            return what.getType() == RemoteItemKeyType.INSTANCE;
        }
    }
}

