/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.tom.stockbridge.ae.AbstractAEStockBridgeBlockEntity;
import com.tom.stockbridge.util.StockBridgeInventory;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AEStockBridgeBlockEntity
extends AbstractAEStockBridgeBlockEntity {
    private StockBridgeInventory inv = new StockBridgeInventory(this);

    public AEStockBridgeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        IGrid grid;
        super.tick();
        if (!this.level.isClientSide && !this.inv.isInsertEmpty() && (grid = this.getMainNode().getGrid()) != null) {
            MEStorage networkInv = grid.getStorageService().getInventory();
            IEnergyService energySrc = grid.getEnergyService();
            for (int slot = 0; slot < this.inv.insertW.getSlots(); ++slot) {
                AEItemKey what;
                int inserted;
                ItemStack is = this.inv.insertW.getStackInSlot(slot);
                if (is.isEmpty() || (inserted = (int)StorageHelper.poweredInsert((IEnergySource)energySrc, (MEStorage)networkInv, (AEKey)(what = AEItemKey.of((ItemStack)is)), (long)is.getCount(), (IActionSource)this.actionSource)) <= 0) continue;
                this.inv.insertW.extractItem(slot, inserted, false);
            }
        }
    }

    @Override
    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(ItemStack stack, int amount, String address, int linkIndex, MutableBoolean finalLink, int orderId, PackageOrderWithCrafts context) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return null;
        }
        PackagerBlockEntity packager = this.getPackager();
        if (packager == null) {
            return null;
        }
        MEStorage networkInv = grid.getStorageService().getInventory();
        IEnergyService energySrc = grid.getEnergyService();
        AEItemKey what = AEItemKey.of((ItemStack)stack);
        long acquired = StorageHelper.poweredExtraction((IEnergySource)energySrc, (MEStorage)networkInv, (AEKey)what, (long)amount, (IActionSource)this.actionSource, (Actionable)Actionable.SIMULATE);
        ItemStack r = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inv.extractW, (ItemStack)stack.copyWithCount((int)acquired), (boolean)true);
        int count = (int)(acquired - (long)r.getCount());
        return Pair.of((Object)packager, (Object)PackagingRequest.create((ItemStack)stack, (int)count, (String)address, (int)linkIndex, (MutableBoolean)finalLink, (int)0, (int)orderId, (PackageOrderWithCrafts)context));
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable action) {
        if (what instanceof AEItemKey) {
            AEItemKey item = (AEItemKey)what;
            ItemStack is = item.toStack((int)amount);
            ItemStack i = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inv.extractW, (ItemStack)is, (action == Actionable.MODULATE ? 1 : 0) != 0);
            return amount - (long)i.getCount();
        }
        return 0L;
    }

    @Override
    public IdentifiedInventory getInvId() {
        return new IdentifiedInventory((InventoryIdentifier)new InventoryIdentifier.Single(this.worldPosition), (IItemHandler)this.inv);
    }

    @Override
    public void pull(PackagingRequest packagingRequest) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        MEStorage networkInv = grid.getStorageService().getInventory();
        IEnergyService energySrc = grid.getEnergyService();
        AEItemKey what = AEItemKey.of((ItemStack)packagingRequest.item());
        long extracted = StorageHelper.poweredExtraction((IEnergySource)energySrc, (MEStorage)networkInv, (AEKey)what, (long)packagingRequest.getCount(), (IActionSource)this.actionSource);
        ItemStack ex = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inv.extractW, (ItemStack)packagingRequest.item().copyWithCount((int)extracted), (boolean)false);
        if (!ex.isEmpty()) {
            // empty if block
        }
        this.sendPulseNextSync();
        this.notifyUpdate();
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (!clientPacket) {
            tag.put("inv", (Tag)this.inv.write(registries));
        }
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (!clientPacket) {
            this.inv.read(tag.getCompound("inv"), registries);
        }
    }

    public StockBridgeInventory getInv() {
        return this.inv;
    }
}

