/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.stockbridge.ae.RemoteItemKeyType;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AERemoteItemKey
extends AEKey {
    public static final MapCodec<AERemoteItemKey> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.ITEM.holderByNameCodec().validate(item -> item.is((Holder)Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)item)).fieldOf("id").forGetter(key -> key.stack.getItemHolder()), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(key -> key.stack.getComponentsPatch())).apply((Applicative)builder, (item, componentPatch) -> new AERemoteItemKey(new ItemStack(item, 1, componentPatch))));
    public static final Codec<AERemoteItemKey> CODEC = MAP_CODEC.codec();
    private final ItemStack stack;
    private final int hashCode;
    private final int maxStackSize;
    private final int damage;
    private final RemoteItem remoteItem;
    private static final LoadingCache<Item, RemoteItem> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(RemoteItem::new));

    private AERemoteItemKey(ItemStack stack) {
        Preconditions.checkArgument((!stack.isEmpty() ? 1 : 0) != 0, (Object)"stack is empty");
        this.stack = stack;
        this.hashCode = ItemStack.hashItemAndComponents((ItemStack)stack);
        this.maxStackSize = stack.getMaxStackSize();
        this.damage = stack.getDamageValue();
        try {
            this.remoteItem = (RemoteItem)CACHE.get((Object)stack.getItem());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static AERemoteItemKey of(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return new AERemoteItemKey(stack.copy());
    }

    public static boolean matches(AEKey what, ItemStack itemStack) {
        AERemoteItemKey itemKey;
        return what instanceof AERemoteItemKey && (itemKey = (AERemoteItemKey)what).matches(itemStack);
    }

    public static boolean is(AEKey what) {
        return what instanceof AERemoteItemKey;
    }

    public static AEKeyFilter filter() {
        return AERemoteItemKey::is;
    }

    public AEKeyType getType() {
        return RemoteItemKeyType.INSTANCE;
    }

    public AERemoteItemKey dropSecondary() {
        return AERemoteItemKey.of(this.stack.getItem().getDefaultInstance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AERemoteItemKey aeItemKey = (AERemoteItemKey)((Object)o);
        return this.hashCode == aeItemKey.hashCode && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)aeItemKey.stack);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AERemoteItemKey of(ItemLike item) {
        return AERemoteItemKey.of(item.asItem().getDefaultInstance());
    }

    public boolean is(ItemLike item) {
        return this.stack.is(item.asItem());
    }

    public boolean matches(ItemStack stack) {
        return !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack);
    }

    public boolean matches(Ingredient ingredient) {
        return ingredient.test(this.getReadOnlyStack());
    }

    public ItemStack getReadOnlyStack() {
        return this.stack;
    }

    public ItemStack toStack() {
        return this.toStack(1);
    }

    public ItemStack toStack(int count) {
        if (count <= 0) {
            return ItemStack.EMPTY;
        }
        return this.stack.copyWithCount(count);
    }

    public Item getItem() {
        return this.stack.getItem();
    }

    @Nullable
    public static AERemoteItemKey fromTag(HolderLookup.Provider registries, CompoundTag tag) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        try {
            return (AERemoteItemKey)((Object)((Pair)CODEC.decode((DynamicOps)ops, (Object)tag).getOrThrow()).getFirst());
        }
        catch (Exception e) {
            AELog.debug((String)"Tried to load an invalid item key from NBT: %s", (Object[])new Object[]{tag, e});
            return null;
        }
    }

    public CompoundTag toTag(HolderLookup.Provider registries) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return (CompoundTag)CODEC.encodeStart((DynamicOps)ops, (Object)this).getOrThrow();
    }

    public Object getPrimaryKey() {
        return this.remoteItem;
    }

    public int getFuzzySearchValue() {
        return this.damage;
    }

    public int getFuzzySearchMaxValue() {
        return this.getReadOnlyStack().getMaxDamage();
    }

    public ResourceLocation getId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem());
    }

    public ItemStack wrapForDisplayOrFilter() {
        return this.toStack();
    }

    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
        while (amount > 0L) {
            if (drops.size() > 1000) {
                AELog.warn((String)"Tried dropping an excessive amount of items, ignoring %s %ss", (Object[])new Object[]{amount, this.stack.getItem()});
                break;
            }
            long taken = Math.min(amount, (long)this.getMaxStackSize());
            amount -= taken;
            drops.add(this.toStack((int)taken));
        }
    }

    protected Component computeDisplayName() {
        return this.getReadOnlyStack().getHoverName();
    }

    public boolean isTagged(TagKey<?> tag) {
        return this.stack.is(tag);
    }

    @Nullable
    public <T> T get(DataComponentType<T> type) {
        return (T)this.stack.get(type);
    }

    public boolean hasComponents() {
        return this.stack.getComponents().isEmpty();
    }

    public boolean isDamaged() {
        return this.damage > 0;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void writeToPacket(RegistryFriendlyByteBuf data) {
        ItemStack.STREAM_CODEC.encode((Object)data, (Object)this.stack);
    }

    public static AERemoteItemKey fromPacket(RegistryFriendlyByteBuf data) {
        ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)data);
        return new AERemoteItemKey(stack);
    }

    public String toString() {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem());
        String idString = id != BuiltInRegistries.ITEM.getDefaultKey() ? id.toString() : this.stack.getItem().getClass().getName() + "(unregistered)";
        return this.stack.isComponentsPatchEmpty() ? idString : idString + " (with patches)";
    }

    public AEItemKey getAsItem() {
        return AEItemKey.of((ItemStack)this.stack);
    }

    public record RemoteItem(Item item) {
    }
}

