/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.createfiltersanywhere.attributes.impl.sophisticatedbackpacks;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.createfiltersanywhere.api.util.sophisticatedbackpacks.SophisticatedBackpackUtil;
import xyz.iwolfking.createfiltersanywhere.attributes.impl.sophisticatedbackpacks.SophisticatedBackpackAttributes;

public record BackpackHasUUIDAttribute(String UUID) implements ItemAttribute
{
    public static final MapCodec<BackpackHasUUIDAttribute> CODEC = Codec.STRING.xmap(BackpackHasUUIDAttribute::new, BackpackHasUUIDAttribute::UUID).fieldOf("value");
    public static final StreamCodec<ByteBuf, BackpackHasUUIDAttribute> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(BackpackHasUUIDAttribute::new, BackpackHasUUIDAttribute::UUID);

    public boolean appliesTo(ItemStack itemStack, Level level) {
        String uuid = SophisticatedBackpackUtil.getBackpackUUID(itemStack);
        return uuid != null && uuid.equals(this.UUID);
    }

    public ItemAttributeType getType() {
        return SophisticatedBackpackAttributes.HAS_BACKPACK_UUID;
    }

    public String getTranslationKey() {
        return "has_backpack_uuid";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.UUID};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new BackpackHasUUIDAttribute("dummy");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = SophisticatedBackpackUtil.getBackpackUUID(stack);
            if (name != null && !name.isEmpty()) {
                list.add(new BackpackHasUUIDAttribute(name));
            }
            return list;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

