/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.trains;

import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.station.GlobalStation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StationChunkLoader
implements ChunkLoader {
    private final GlobalStation station;
    public final Set<AttachedLoader> attachments = new HashSet<AttachedLoader>();
    private final Map<ResourceKey<Level>, Set<ChunkLoadManager.LoadedChunkPos>> reclaimedChunks = new HashMap<ResourceKey<Level>, Set<ChunkLoadManager.LoadedChunkPos>>();
    public final Set<ChunkLoadManager.LoadedChunkPos> forcedChunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
    private boolean registered = false;

    public StationChunkLoader(GlobalStation station) {
        this.station = station;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        return this.forcedChunks;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.STATION;
    }

    @Override
    public LoaderType getLoaderType() {
        for (AttachedLoader attachment : this.attachments) {
            if (attachment.type() != LoaderType.BRASS) continue;
            return LoaderType.BRASS;
        }
        return LoaderType.ANDESITE;
    }

    @Override
    @Nullable
    public Pair<ResourceLocation, BlockPos> getLocation() {
        return Pair.of((Object)((TrackNodeLocation)this.station.edgeLocation.getFirst()).dimension.location(), (Object)BlockPos.containing((Position)((TrackNodeLocation)this.station.edgeLocation.getFirst()).getLocation().add(((TrackNodeLocation)this.station.edgeLocation.getSecond()).getLocation()).scale(0.5)));
    }

    @Override
    public void addToManager() {
        if (!this.registered) {
            ChunkLoader.super.addToManager();
            this.registered = true;
        }
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        if (preTrains) {
            return;
        }
        Level level = ChunkLoadManager.tickLevel;
        if (level == null || level.isClientSide()) {
            return;
        }
        this.addToManager();
        ChunkLoadManager.reclaimChunks(level, this.station.id, this.reclaimedChunks);
        if (this.attachments.isEmpty() || this.station.getPresentTrain() == null) {
            if (!this.forcedChunks.isEmpty()) {
                ChunkLoadManager.unforceAllChunks(level.getServer(), this.station.id, this.forcedChunks);
            }
            return;
        }
        this.attachments.removeIf(a -> a.pos.distManhattan((Vec3i)this.station.blockEntityPos) > 1);
        HashSet<ChunkLoadManager.LoadedChunkPos> loadTargets = new HashSet<ChunkLoadManager.LoadedChunkPos>();
        for (AttachedLoader attachment : this.attachments) {
            if (!StationChunkLoader.isEnabledForStation(attachment.type())) continue;
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(this.station.blockEntityDimension.location(), new ChunkPos(attachment.pos())));
        }
        ChunkLoadManager.updateForcedChunks(level.getServer(), loadTargets, this.station.id, (int)((Integer)CPLConfigs.server().getFor((LoaderType)this.getLoaderType()).rangeOnStation.get()), this.forcedChunks);
    }

    public static boolean isEnabledForStation(LoaderType type) {
        return (Boolean)CPLConfigs.server().getFor((LoaderType)type).enableStation.get();
    }

    public void removeAttachment(BlockPos pos) {
        this.attachments.removeIf(t -> t.pos.equals((Object)pos));
    }

    public void addAttachment(LoaderType type, BlockPos pos) {
        this.removeAttachment(pos);
        this.attachments.add(new AttachedLoader(type, pos));
    }

    public void onRemove() {
        ChunkLoadManager.enqueueUnforceAll(this.station.id, this.forcedChunks);
        this.removeFromManager();
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("Attachments", (Tag)NBTHelper.writeCompoundList(this.attachments, AttachedLoader::write));
        return nbt;
    }

    public static StationChunkLoader read(GlobalStation station, CompoundTag nbt) {
        StationChunkLoader loader = new StationChunkLoader(station);
        loader.attachments.clear();
        loader.attachments.addAll(NBTHelper.readCompoundList((ListTag)nbt.getList("Attachments", 10), AttachedLoader::read));
        return loader;
    }

    public record AttachedLoader(LoaderType type, BlockPos pos) {
        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            NBTHelper.writeEnum((CompoundTag)nbt, (String)"Type", (Enum)this.type);
            nbt.put("Pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
            return nbt;
        }

        public static AttachedLoader read(CompoundTag nbt) {
            return new AttachedLoader((LoaderType)NBTHelper.readEnum((CompoundTag)nbt, (String)"Type", LoaderType.class), (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"Pos").orElseThrow());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AttachedLoader)) {
                return false;
            }
            AttachedLoader loader = (AttachedLoader)obj;
            if (this.type != loader.type) {
                return false;
            }
            return Objects.equals(this.pos, loader.pos);
        }
    }
}

