/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.cak.pattern_schematics.registry.PatternSchematicsDataComponents;
import com.simibubi.create.content.schematics.SchematicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.createmod.catnip.levelWrappers.SchematicChunkSource;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.math.BBHelper;
import net.createmod.ponder.Ponder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;

public class PatternSchematicLevel
extends SchematicLevel {
    public Vec3i cloneScaleMin;
    public Vec3i cloneScaleMax;
    public Vec3i cloneOffset;
    public BoundingBox sourceBounds;
    public BoundingBox printBounds;

    public PatternSchematicLevel(BlockPos anchor, Level original) {
        super(anchor, original);
        this.setChunkSource((ChunkSource)new SchematicChunkSource((Level)this));
        this.blocks = new HashMap();
        this.blockEntities = new HashMap();
        this.bounds = new BoundingBox(BlockPos.ZERO);
        this.anchor = anchor;
        this.entities = new ArrayList();
        this.renderedBlockEntities = new ArrayList();
    }

    public void putExtraData(ItemStack blueprint, StructureTemplate template) {
        this.cloneScaleMin = (Vec3i)blueprint.getOrDefault(PatternSchematicsDataComponents.SCHEMATIC_CLONE_SCALE_MIN, (Object)Vec3i.ZERO);
        this.cloneScaleMax = (Vec3i)blueprint.getOrDefault(PatternSchematicsDataComponents.SCHEMATIC_CLONE_SCALE_MAX, (Object)Vec3i.ZERO);
        this.cloneOffset = (Vec3i)blueprint.getOrDefault(PatternSchematicsDataComponents.SCHEMATIC_CLONE_OFFSET, (Object)Vec3i.ZERO);
        this.printBounds = this.sourceBounds = template.getBoundingBox(SchematicItem.getSettings((ItemStack)blueprint), this.anchor);
    }

    public boolean addFreshEntity(Entity entityIn) {
        return this.applyToClones(clonePos -> {
            Entity newEntity = this.cloneEntity(entityIn);
            newEntity.setPos(this.applyCloneToRealLoc(newEntity.position(), (Vec3i)clonePos));
            return super.addFreshEntity(newEntity);
        });
    }

    protected Entity cloneEntity(Entity source) {
        CompoundTag tag = new CompoundTag();
        source.save(tag);
        Entity newEntity = (Entity)EntityType.create((CompoundTag)tag, (Level)this.level).orElseThrow();
        newEntity.setUUID(UUID.randomUUID());
        return newEntity;
    }

    protected boolean applyToClones(Function<Vec3i, Boolean> function) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.forEachClone(clonePos -> {
            if (((Boolean)function.apply((Vec3i)clonePos)).booleanValue()) {
                result.set(true);
            }
        });
        return result.get();
    }

    protected void forEachClone(Consumer<Vec3i> consumer) {
        for (int x = this.cloneScaleMin.getX(); x <= this.cloneScaleMax.getX(); ++x) {
            for (int y = this.cloneScaleMin.getY(); y <= this.cloneScaleMax.getY(); ++y) {
                for (int z = this.cloneScaleMin.getZ(); z <= this.cloneScaleMax.getZ(); ++z) {
                    consumer.accept(new Vec3i(x, y, z));
                }
            }
        }
    }

    public BoundingBox genBounds(BoundingBox originalBounds, StructurePlaceSettings placeSettings) {
        return originalBounds;
    }

    protected Vec3 applyCloneToRealLoc(Vec3 local, Vec3i clone) {
        return local.add(Vec3.atLowerCornerOf((Vec3i)Vec3iUtils.multiplyVec3i(clone, this.sourceBounds.getLength().offset(1, 1, 1))));
    }

    public Set<BlockPos> getAllPositions() {
        return this.blocks.keySet();
    }

    public List<Entity> getEntityList() {
        return this.entities;
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        if (this.isOutsideBuildHeight(pos)) {
            return null;
        }
        if (this.blockEntities.containsKey(pos)) {
            return (BlockEntity)this.blockEntities.get(pos);
        }
        if (!this.blocks.containsKey(pos.subtract((Vec3i)this.anchor))) {
            return null;
        }
        BlockState blockState = this.getBlockState(pos);
        if (blockState.hasBlockEntity()) {
            try {
                BlockEntity blockEntity = ((EntityBlock)blockState.getBlock()).newBlockEntity(pos, blockState);
                if (blockEntity != null) {
                    this.onBEadded(blockEntity, pos);
                    this.blockEntities.put(pos, blockEntity);
                    this.renderedBlockEntities.add(blockEntity);
                }
                return blockEntity;
            }
            catch (Exception e) {
                Ponder.LOGGER.debug("Could not create BlockEntity of block " + String.valueOf(blockState), (Throwable)e);
            }
        }
        return null;
    }

    protected void onBEadded(BlockEntity blockEntity, BlockPos pos) {
        blockEntity.setLevel((Level)this);
    }

    public BlockState getBlockState(BlockPos globalPos) {
        BlockPos pos = globalPos.subtract((Vec3i)this.anchor);
        if (pos.getY() - this.bounds.minY() == -1 && !this.renderMode) {
            return Blocks.DIRT.defaultBlockState();
        }
        if (this.getBounds().isInside((Vec3i)pos) && this.blocks.containsKey(pos)) {
            return this.processBlockStateForPrinting((BlockState)this.blocks.get(pos));
        }
        return Blocks.AIR.defaultBlockState();
    }

    public Map<BlockPos, BlockState> getBlockMap() {
        return this.blocks;
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public Holder<Biome> getBiome(BlockPos pos) {
        return this.level.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
    }

    public int getBrightness(LightLayer lightLayer, BlockPos pos) {
        return 15;
    }

    public float getShade(Direction face, boolean hasShade) {
        return 1.0f;
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public List<Entity> getEntities(Entity arg0, AABB arg1, Predicate<? super Entity> arg2) {
        return Collections.emptyList();
    }

    public <T extends Entity> List<T> getEntitiesOfClass(Class<T> arg0, AABB arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    public List<? extends Player> players() {
        return Collections.emptyList();
    }

    public int getSkyDarken() {
        return 0;
    }

    public boolean isStateAtPosition(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.getBlockState(pos));
    }

    public boolean destroyBlock(BlockPos arg0, boolean arg1) {
        return this.setBlock(arg0, Blocks.AIR.defaultBlockState(), 3);
    }

    public boolean removeBlock(BlockPos arg0, boolean arg1) {
        return this.setBlock(arg0, Blocks.AIR.defaultBlockState(), 3);
    }

    public boolean setBlock(BlockPos pos, BlockState arg1, int arg2) {
        BlockEntity blockEntity;
        pos = pos.immutable().subtract((Vec3i)this.anchor);
        this.bounds = BBHelper.encapsulate((BoundingBox)this.bounds, (BlockPos)pos);
        this.blocks.put(pos, arg1);
        if (this.blockEntities.containsKey(pos) && !(blockEntity = (BlockEntity)this.blockEntities.get(pos)).getType().isValid(arg1)) {
            this.blockEntities.remove(pos);
            this.renderedBlockEntities.remove(blockEntity);
        }
        if ((blockEntity = this.getBlockEntity(pos)) != null) {
            this.blockEntities.put(pos, blockEntity);
        }
        return true;
    }

    public void sendBlockUpdated(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setBounds(BoundingBox bounds) {
        this.bounds = bounds;
    }

    public Iterable<BlockEntity> getBlockEntities() {
        return this.blockEntities.values();
    }

    public Iterable<BlockEntity> getRenderedBlockEntities() {
        return this.renderedBlockEntities;
    }

    protected BlockState processBlockStateForPrinting(BlockState state) {
        if (state.getBlock() instanceof AbstractFurnaceBlock && state.hasProperty((Property)BlockStateProperties.LIT)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ServerLevel getLevel() {
        if (this.level instanceof ServerLevel) {
            return (ServerLevel)this.level;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}

