/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.gui.AllIcons;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SingleIcon
extends AllIcons {
    public static final int SOURCE_SIZE = 16;
    public ResourceLocation source;
    private int iconX;
    private int iconY;

    public SingleIcon(int x, int y, ResourceLocation source) {
        super(x, y);
        this.iconX = x * 16;
        this.iconY = y * 16;
        this.source = source;
    }

    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.source);
    }

    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.source, x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 16, 16);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.getBuffer(RenderType.text((ResourceLocation)this.source));
        Matrix4f matrix = ms.last().pose();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX * 1.0f / 16.0f;
        float u2 = (float)(this.iconX + 16) * 1.0f / 16.0f;
        float v1 = (float)this.iconY * 1.0f / 16.0f;
        float v2 = (float)(this.iconY + 16) * 1.0f / 16.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.addVertex(matrix, (float)vec.x, (float)vec.y, (float)vec.z).setColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).setUv(u, v).setLight(light);
    }

    public DelegatedStencilElement asStencil() {
        return (DelegatedStencilElement)new DelegatedStencilElement().withStencilRenderer((ms, w, h, alpha) -> this.render(ms, 0, 0)).withBounds(16, 16);
    }
}

