/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.sound;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class TubeSound
extends AbstractTickableSoundInstance {
    private float pitch;

    public TubeSound(SoundEvent soundEvent, float pitch) {
        super(soundEvent, SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.pitch = pitch;
        this.volume = 0.01f;
        this.looping = true;
        this.delay = 0;
        this.relative = true;
    }

    public void tick() {
    }

    public void fadeIn(float maxVolume) {
        this.volume = Math.min(maxVolume, this.volume + 0.05f);
    }

    public void fadeOut() {
        this.volume = Math.max(0.0f, this.volume - 0.05f);
    }

    public boolean isFaded() {
        return this.volume == 0.0f;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void stopSound() {
        this.stop();
    }

    public void updateLocation(Vec3 pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public boolean isRelative() {
        return true;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }
}

