/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.config;

import com.hlysine.create_connected.config.FeatureToggle;
import com.hlysine.create_connected.config.SyncConfigBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class CFeatures
extends SyncConfigBase {
    final Map<ResourceLocation, ModConfigSpec.ConfigValue<Boolean>> toggles = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Boolean>>();
    Map<ResourceLocation, Boolean> synchronizedToggles;

    @NotNull
    public String getName() {
        return "features";
    }

    public void registerAll(ModConfigSpec.Builder builder) {
        FeatureToggle.TOGGLEABLE_FEATURES.forEach(r -> this.toggles.put((ResourceLocation)r, (ModConfigSpec.ConfigValue<Boolean>)builder.define(r.getPath(), true)));
    }

    public boolean hasToggle(ResourceLocation key) {
        return this.synchronizedToggles != null && this.synchronizedToggles.containsKey(key) || this.toggles.containsKey(key);
    }

    public boolean isEnabled(ResourceLocation key) {
        Boolean synced;
        if (this.synchronizedToggles != null && (synced = this.synchronizedToggles.get(key)) != null) {
            return synced;
        }
        ModConfigSpec.ConfigValue<Boolean> value = this.toggles.get(key);
        if (value != null) {
            return (Boolean)value.get();
        }
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    public void onReload() {
        super.onReload();
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    protected void readSyncConfig(CompoundTag nbt) {
        this.synchronizedToggles = new HashMap<ResourceLocation, Boolean>();
        for (String key : nbt.getAllKeys()) {
            ResourceLocation location = ResourceLocation.parse((String)key);
            this.synchronizedToggles.put(location, nbt.getBoolean(key));
        }
        FeatureToggle.refreshItemVisibility();
    }

    @Override
    protected void writeSyncConfig(CompoundTag nbt) {
        this.toggles.forEach((key, value) -> nbt.putBoolean(key.toString(), ((Boolean)value.get()).booleanValue()));
    }
}

