/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.compat;

import com.copycatsplus.copycats.config.FeatureToggle;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.compat.Mods;
import com.hlysine.create_connected.config.CCConfigs;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class CopycatsManager {
    public static Map<String, BlockEntry<?>> BLOCK_MAP = new HashMap();
    public static Map<String, ItemEntry<?>> ITEM_MAP = new HashMap();
    public static final Map<Level, Set<BlockPos>> migrationQueue = Collections.synchronizedMap(new WeakHashMap());

    public static Block convert(Block self) {
        ResourceLocation key = RegisteredObjectsHelper.getKeyOrThrow((Block)self);
        if (!CopycatsManager.validateNamespace(key)) {
            return self;
        }
        BlockEntry<?> result = BLOCK_MAP.get(key.getPath());
        if (result != null) {
            return (Block)result.get();
        }
        return self;
    }

    public static Item convert(Item self) {
        ResourceLocation key = RegisteredObjectsHelper.getKeyOrThrow((Item)self);
        if (!CopycatsManager.validateNamespace(key)) {
            return self;
        }
        ItemEntry<?> result = ITEM_MAP.get(key.getPath());
        if (result != null) {
            return (Item)result.get();
        }
        BlockEntry<?> blockResult = BLOCK_MAP.get(key.getPath());
        if (blockResult != null) {
            return blockResult.asItem();
        }
        return self;
    }

    public static ItemLike convert(ItemLike self) {
        return CopycatsManager.convert(self.asItem());
    }

    public static BlockState convert(BlockState state) {
        Block converted = CopycatsManager.convert(state.getBlock());
        if (state.getBlock() == converted) {
            return state;
        }
        BlockState newState = converted.defaultBlockState();
        for (Property property : state.getProperties()) {
            newState = CopycatsManager.copyProperty(state, newState, property);
        }
        return newState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState from, BlockState to, Property<T> property) {
        return from.getOptionalValue(property).map(value -> (BlockState)to.trySetValue(property, value)).orElse(to);
    }

    public static Block convertIfEnabled(Block block) {
        ResourceLocation key = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        if (!CopycatsManager.validateNamespace(key)) {
            return block;
        }
        if (CopycatsManager.isFeatureEnabled(key)) {
            return CopycatsManager.convert(block);
        }
        return block;
    }

    public static BlockState convertIfEnabled(BlockState state) {
        ResourceLocation key = RegisteredObjectsHelper.getKeyOrThrow((Block)state.getBlock());
        if (!CopycatsManager.validateNamespace(key)) {
            return state;
        }
        if (CopycatsManager.isFeatureEnabled(key)) {
            return CopycatsManager.convert(state);
        }
        return state;
    }

    public static ItemLike convertIfEnabled(ItemLike item) {
        ResourceLocation key = RegisteredObjectsHelper.getKeyOrThrow((Item)item.asItem());
        if (!CopycatsManager.validateNamespace(key)) {
            return item;
        }
        if (CopycatsManager.isFeatureEnabled(key)) {
            return CopycatsManager.convert(item);
        }
        return item;
    }

    private static boolean validateNamespace(ResourceLocation key) {
        return key.getNamespace().equals("create_connected") || key.getNamespace().equals(Mods.COPYCATS.id());
    }

    public static boolean existsInCopycats(ResourceLocation key) {
        if (!CopycatsManager.validateNamespace(key)) {
            return false;
        }
        if (BLOCK_MAP.containsKey(key.getPath())) {
            return true;
        }
        return ITEM_MAP.containsKey(key.getPath());
    }

    public static boolean isFeatureEnabled(ResourceLocation key) {
        if (!CopycatsManager.existsInCopycats(key)) {
            return false;
        }
        return FeatureToggle.isEnabled((ResourceLocation)Mods.COPYCATS.rl(key.getPath()));
    }

    public static void enqueueMigration(Level level, BlockPos pos) {
        migrationQueue.computeIfAbsent(level, $ -> Collections.synchronizedSet(new LinkedHashSet())).add(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onLevelTick(LevelTickEvent.Post event) {
        if (event.hasTime() && !event.getLevel().isClientSide()) {
            if (!((Boolean)CCConfigs.common().migrateCopycatsOnInitialize.get()).booleanValue()) {
                migrationQueue.clear();
                return;
            }
            Level level = event.getLevel();
            Map<Level, Set<BlockPos>> map = migrationQueue;
            synchronized (map) {
                if (migrationQueue.containsKey(level)) {
                    Set<BlockPos> list;
                    Set<BlockPos> set = list = migrationQueue.get(level);
                    synchronized (set) {
                        if (list.size() > 0) {
                            CreateConnected.LOGGER.debug("Copycats: Migrated " + list.size() + " copycats in " + String.valueOf(level.dimension().location()));
                        }
                        Iterator<BlockPos> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            BlockEntity be;
                            BlockPos pos = iterator.next();
                            if (!level.isLoaded(pos)) {
                                iterator.remove();
                                continue;
                            }
                            BlockState state = level.getBlockState(pos);
                            BlockState converted = CopycatsManager.convert(state);
                            if (!converted.is(state.getBlock())) {
                                level.setBlock(pos, converted, 50);
                            }
                            if ((be = level.getBlockEntity(pos)) != null) {
                                level.setBlockEntity(be);
                            }
                            iterator.remove();
                        }
                    }
                }
            }
        }
    }

    static {
        BLOCK_MAP.put(CCBlocks.COPYCAT_BLOCK.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_BLOCK);
        BLOCK_MAP.put(CCBlocks.COPYCAT_SLAB.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_SLAB);
        BLOCK_MAP.put(CCBlocks.COPYCAT_BEAM.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_BEAM);
        BLOCK_MAP.put(CCBlocks.COPYCAT_VERTICAL_STEP.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_VERTICAL_STEP);
        BLOCK_MAP.put(CCBlocks.COPYCAT_STAIRS.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_STAIRS);
        BLOCK_MAP.put(CCBlocks.COPYCAT_FENCE.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_FENCE);
        BLOCK_MAP.put(CCBlocks.COPYCAT_FENCE_GATE.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_FENCE_GATE);
        BLOCK_MAP.put(CCBlocks.COPYCAT_WALL.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_WALL);
        BLOCK_MAP.put(CCBlocks.COPYCAT_BOARD.getKey().location().getPath(), com.copycatsplus.copycats.CCBlocks.COPYCAT_BOARD);
        ITEM_MAP.put(CCItems.COPYCAT_BOX.getKey().location().getPath(), com.copycatsplus.copycats.CCItems.COPYCAT_BOX);
        ITEM_MAP.put(CCItems.COPYCAT_CATWALK.getKey().location().getPath(), com.copycatsplus.copycats.CCItems.COPYCAT_CATWALK);
    }
}

