/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected;

import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.compat.Mods;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class CCTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return CCTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return CCTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return CCTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return CCTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        Items.init();
    }

    public static enum Items {
        COPYCAT_BEAM(NameSpace.COPYCATS),
        COPYCAT_BLOCK(NameSpace.COPYCATS),
        COPYCAT_BOARD(NameSpace.COPYCATS),
        COPYCAT_BOX(NameSpace.COPYCATS),
        COPYCAT_CATWALK(NameSpace.COPYCATS),
        COPYCAT_FENCE(NameSpace.COPYCATS),
        COPYCAT_FENCE_GATE(NameSpace.COPYCATS),
        COPYCAT_SLAB(NameSpace.COPYCATS),
        COPYCAT_STAIRS(NameSpace.COPYCATS),
        COPYCAT_VERTICAL_STEP(NameSpace.COPYCATS),
        COPYCAT_WALL(NameSpace.COPYCATS);

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private Items() {
            this(NameSpace.MOD);
        }

        private Items(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Items(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Items(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private Items(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? ConnectedLang.asId((String)this.name()) : path));
            this.tag = optional ? CCTags.optionalTag(BuiltInRegistries.ITEM, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum Fluids {
        FAN_PROCESSING_CATALYSTS_ENDING(NameSpace.DRAGONS_PLUS, "fan_processing_catalysts/ending");

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private Fluids() {
            this(NameSpace.MOD);
        }

        private Fluids(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Fluids(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Fluids(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private Fluids(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CCTags.optionalTag(BuiltInRegistries.FLUID, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create_connected", false, true),
        COPYCATS(Mods.COPYCATS.id()),
        DRAGONS_PLUS(Mods.DRAGONS_PLUS.id());

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

