/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hlysine.create_connected.CreateConnected;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

public class CCSoundEvents {
    public static final Map<ResourceLocation, SoundEntry> ALL = new HashMap<ResourceLocation, SoundEntry>();
    public static final SoundEntry ELEVATOR_MUSIC = CCSoundEvents.create("elevator_music").noSubtitle().category(SoundSource.RECORDS).attenuationDistance(7).build();
    public static final SoundEntry INTERLUDE_MUSIC = CCSoundEvents.create("interlude_music").noSubtitle().category(SoundSource.RECORDS).attenuationDistance(7).build();

    private static SoundEntryBuilder create(String name) {
        return CCSoundEvents.create(CreateConnected.asResource(name));
    }

    public static SoundEntryBuilder create(ResourceLocation id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.SOUND_EVENT, helper -> {
            for (SoundEntry entry : ALL.values()) {
                entry.register((RegisterEvent.RegisterHelper<SoundEvent>)helper);
            }
        });
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    public static void playItemPickup(Player player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + player.level().random.nextFloat());
    }

    public static class SoundEntryBuilder {
        protected ResourceLocation id;
        protected String subtitle = "unregistered";
        protected SoundSource category = SoundSource.BLOCKS;
        protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
        protected List<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        protected int attenuationDistance;

        public SoundEntryBuilder(ResourceLocation id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(SoundSource category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder addVariant(String name) {
            return this.addVariant(CreateConnected.asResource(name));
        }

        public SoundEntryBuilder addVariant(ResourceLocation id) {
            this.variants.add(id);
            return this;
        }

        public SoundEntryBuilder playExisting(Supplier<SoundEvent> event, float volume, float pitch) {
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public SoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntryBuilder playExisting(Holder<SoundEvent> event) {
            return this.playExisting(() -> event.value(), 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    public static abstract class SoundEntry {
        protected ResourceLocation id;
        protected String subtitle;
        protected SoundSource category;
        protected int attenuationDistance;

        public SoundEntry(ResourceLocation id, String subtitle, SoundSource category, int attenuationDistance) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        public abstract void prepare();

        public abstract void register(RegisterEvent.RegisterHelper<SoundEvent> var1);

        public abstract void write(JsonObject var1);

        public abstract Holder<SoundEvent> getMainEventHolder();

        public abstract SoundEvent getMainEvent();

        public String getSubtitleKey() {
            return this.id.getNamespace() + ".subtitle." + this.id.getPath();
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void playOnServer(Level world, Vec3i pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(Level world, Vec3i pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3i pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity, float volume, float pitch) {
            if (!entity.isSilent()) {
                this.play(entity.level(), null, (Vec3i)entity.blockPosition(), volume, pitch);
            }
        }

        public void play(Level world, Player entity, Vec3i pos, float volume, float pitch) {
            this.play(world, entity, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3 pos, float volume, float pitch) {
            this.play(world, entity, pos.x(), pos.y(), pos.z(), volume, pitch);
        }

        public abstract void play(Level var1, Player var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(Level world, Vec3i pos, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume, pitch, fade);
        }

        public void playAt(Level world, Vec3 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, pos.x(), pos.y(), pos.z(), volume, pitch, fade);
        }

        public abstract void playAt(Level var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    public static class SoundEntryProvider
    implements DataProvider {
        private PackOutput output;

        public SoundEntryProvider(DataGenerator generator) {
            this.output = generator.getPackOutput();
        }

        public CompletableFuture<?> run(CachedOutput cache) {
            return this.generate(this.output.getOutputFolder(), cache);
        }

        public String getName() {
            return "Create Connected's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/create_connected");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }

    private static class CustomSoundEntry
    extends SoundEntry {
        protected List<ResourceLocation> variants;
        protected DeferredHolder<SoundEvent, SoundEvent> event;
        protected Holder<SoundEvent> directEvent;

        public CustomSoundEntry(ResourceLocation id, List<ResourceLocation> variants, String subtitle, SoundSource category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.variants = variants;
        }

        @Override
        public void prepare() {
            this.event = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)this.id);
        }

        @Override
        public void register(RegisterEvent.RegisterHelper<SoundEvent> helper) {
            ResourceLocation location = this.event.getId();
            helper.register(location, (Object)SoundEvent.createVariableRangeEvent((ResourceLocation)location));
        }

        @Override
        public Holder<SoundEvent> getMainEventHolder() {
            if (this.directEvent == null) {
                this.directEvent = Holder.direct((Object)this.getMainEvent());
            }
            return this.directEvent;
        }

        @Override
        public SoundEvent getMainEvent() {
            return (SoundEvent)this.event.get();
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", this.id.toString());
            s.addProperty("type", "file");
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            for (ResourceLocation variant : this.variants) {
                s = new JsonObject();
                s.addProperty("name", variant.toString());
                s.addProperty("type", "file");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.id.getPath(), (JsonElement)entry);
        }

        @Override
        public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
            world.playSound(entity, x, y, z, (SoundEvent)this.event.get(), this.category, volume, pitch);
        }

        @Override
        public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            world.playLocalSound(x, y, z, (SoundEvent)this.event.get(), this.category, volume, pitch, fade);
        }
    }

    private static class WrappedSoundEntry
    extends SoundEntry {
        private List<ConfiguredSoundEvent> wrappedEvents;
        private List<CompiledSoundEvent> compiledEvents;

        public WrappedSoundEntry(ResourceLocation id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, SoundSource category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = new ArrayList<CompiledSoundEvent>();
        }

        @Override
        public void prepare() {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
                ResourceLocation location = this.getIdOf(i);
                DeferredHolder event = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)location);
                this.compiledEvents.add(new CompiledSoundEvent((DeferredHolder<SoundEvent, SoundEvent>)event, wrapped.volume(), wrapped.pitch()));
            }
        }

        @Override
        public void register(RegisterEvent.RegisterHelper<SoundEvent> helper) {
            for (CompiledSoundEvent compiledEvent : this.compiledEvents) {
                ResourceLocation location = compiledEvent.event().getId();
                helper.register(location, (Object)SoundEvent.createVariableRangeEvent((ResourceLocation)location));
            }
        }

        @Override
        public Holder<SoundEvent> getMainEventHolder() {
            return this.compiledEvents.getFirst().event();
        }

        @Override
        public SoundEvent getMainEvent() {
            return (SoundEvent)this.compiledEvents.getFirst().event().get();
        }

        protected ResourceLocation getIdOf(int i) {
            return ResourceLocation.fromNamespaceAndPath((String)this.id.getNamespace(), (String)(i == 0 ? this.id.getPath() : this.id.getPath() + "_compounded_" + i));
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent event = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event.event().get().getLocation().toString());
                s.addProperty("type", "event");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i).getPath(), (JsonElement)entry);
            }
        }

        @Override
        public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                world.playSound(entity, x, y, z, (SoundEvent)event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch);
            }
        }

        @Override
        public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                world.playLocalSound(x, y, z, (SoundEvent)event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
            }
        }

        private record CompiledSoundEvent(DeferredHolder<SoundEvent, SoundEvent> event, float volume, float pitch) {
        }
    }

    public record ConfiguredSoundEvent(Supplier<SoundEvent> event, float volume, float pitch) {
    }
}

