/*
 * Decompiled with CFR 0.152.
 */
package dev.szedann.create_bluemap;

import com.flowpowered.math.vector.Vector3d;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.LineMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Line;
import dev.szedann.create_bluemap.Config;
import java.util.HashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.phys.Vec3;

public class Trains {
    private static final Color manualColor = new Color("#f99");
    private static final Color scheduledColor = new Color("#99f");

    public static void update(BlueMapAPI api) {
        if (Config.renderTrains) {
            Trains.updatePOIs(api);
        }
        if (Config.renderCarriages) {
            Trains.updateCarriages(api);
        }
    }

    private static void updatePOIs(BlueMapAPI api) {
        HashMap<ResourceKey, MarkerSet> POIMarkerSets = new HashMap<ResourceKey, MarkerSet>();
        Create.RAILWAYS.trains.forEach((uuid, train) -> {
            TrackNode node = ((Carriage)train.carriages.get((int)0)).getLeadingPoint().node1;
            if (node == null) {
                return;
            }
            ResourceKey level = node.getLocation().dimension;
            if (!POIMarkerSets.containsKey(level)) {
                POIMarkerSets.put(level, MarkerSet.builder().defaultHidden(Boolean.valueOf(true)).label(String.format("Trains in %s", level.location().toShortLanguageKey())).build());
            }
            Vec3 pos = ((Carriage)train.carriages.get(0)).getLeadingPoint().getPosition(train.graph);
            POIMarker marker = ((POIMarker.Builder)((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label(train.name.getString())).position(pos.x, pos.y, pos.z)).maxDistance(150.0)).build();
            ((MarkerSet)POIMarkerSets.get(level)).put(uuid.toString(), (Marker)marker);
        });
        POIMarkerSets.forEach((level, markerSet) -> api.getWorld(level).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                map.getMarkerSets().put(String.format("trains-%s", level.location().toShortLanguageKey()), markerSet);
            }
        }));
    }

    private static void updateCarriages(BlueMapAPI api) {
        HashMap<ResourceKey, MarkerSet> lineMarkerMap = new HashMap<ResourceKey, MarkerSet>();
        Create.RAILWAYS.trains.forEach((uuid, train) -> {
            int i = 0;
            for (Carriage carriage : train.carriages) {
                TrackNode node = carriage.getLeadingPoint().node1;
                if (node == null) {
                    return;
                }
                ResourceKey level = node.getLocation().dimension;
                if (carriage.getTrailingPoint().node2.getLocation().dimension != level) {
                    return;
                }
                if (!lineMarkerMap.containsKey(level)) {
                    lineMarkerMap.put(level, MarkerSet.builder().label(String.format("Carriages in %s", level.location().toShortLanguageKey())).build());
                }
                Vec3 p1 = carriage.getLeadingPoint().getPosition(train.graph);
                Vec3 p2 = carriage.getTrailingPoint().getPosition(train.graph);
                boolean front = train.currentlyBackwards ? i == train.carriages.size() : ++i == 1;
                boolean scheduled = train.runtime.state == ScheduleRuntime.State.IN_TRANSIT;
                ((MarkerSet)lineMarkerMap.get(level)).put(train.id.toString() + "-" + carriage.id, (Marker)((LineMarker.Builder)LineMarker.builder().label(String.format("%s carriage %s", train.name.getString(), i))).line(Line.builder().addPoint(new Vector3d(p1.x, p1.y + 1.0, p1.z)).addPoint(new Vector3d(p2.x, p2.y + 1.0, p2.z)).build()).lineColor(scheduled ? scheduledColor : manualColor).lineWidth(front ? 7 : 5).depthTestEnabled(false).build());
            }
        });
        lineMarkerMap.forEach((level, markerSet) -> api.getWorld(level).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                map.getMarkerSets().put(String.format("carriages-%s", level.location().toShortLanguageKey()), markerSet);
            }
        }));
    }
}

