/*
 * Decompiled with CFR 0.152.
 */
package dev.szedann.create_bluemap;

import com.flowpowered.math.vector.Vector3d;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.LineMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Line;
import dev.szedann.create_bluemap.Config;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.phys.Vec3;

public class Tracks {
    private static final Color trackColor = new Color("#fff");

    public static void update(BlueMapAPI api) {
        if (!Config.renderTracks) {
            return;
        }
        HashMap<ResourceKey, MarkerSet> lineMarkerSets = new HashMap<ResourceKey, MarkerSet>();
        Create.RAILWAYS.trackNetworks.forEach((graphUuid, graph) -> {
            HashSet edges = new HashSet();
            graph.getNodes().forEach(graphNode -> {
                TrackNode node = graph.locateNode(graphNode);
                edges.addAll(graph.getConnectionsFrom(node).values());
                ResourceKey level = node.getLocation().dimension;
                if (!lineMarkerSets.containsKey(level)) {
                    lineMarkerSets.put(level, MarkerSet.builder().defaultHidden(Boolean.valueOf(true)).label(String.format("Tracks in %s", level.location().toShortLanguageKey())).build());
                }
            });
            edges.forEach(edge -> {
                MarkerSet lineMarkerSet = (MarkerSet)lineMarkerSets.get(edge.node1.getLocation().dimension);
                if (edge.isInterDimensional()) {
                    return;
                }
                Line.Builder line = Line.builder();
                Tracks.addEdge(line, edge, graph, false);
                LineMarker marker = ((LineMarker.Builder)((LineMarker.Builder)LineMarker.builder().line(line.build()).lineWidth(6).label("edge")).depthTestEnabled(false).listed(Boolean.valueOf(false))).lineColor(trackColor).build();
                lineMarkerSet.put(edge.toString(), (Marker)marker);
            });
        });
        lineMarkerSets.forEach((level, markerSet) -> api.getWorld(level).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                map.getMarkerSets().put(String.format("tracks-%s", level.location().toShortLanguageKey()), markerSet);
            }
        }));
    }

    public static void addEdge(Line.Builder line, TrackEdge edge, TrackGraph graph, boolean skipFirst) {
        int i;
        int segmentCount = edge.isTurn() ? (int)(edge.getLength() / 16.0) + 2 : 2;
        int n = i = skipFirst ? 1 : 0;
        while (i < segmentCount) {
            Vec3 pos = edge.getPosition(graph, (double)i / (double)(segmentCount - 1));
            line.addPoint(new Vector3d(pos.x, pos.y + 1.0, pos.z));
            ++i;
        }
    }
}

