/*
 * Decompiled with CFR 0.152.
 */
package dev.szedann.create_bluemap;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="create_bluemap", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue INTERVAL_TRAINS = BUILDER.comment("Interval between train updates").defineInRange("interval", 5, 1, 30);
    private static final ModConfigSpec.IntValue INTERVAL_TRACKS = BUILDER.comment("Interval between track updates").defineInRange("interval_tracks", 30, 10, 240);
    private static final ModConfigSpec.BooleanValue RENDER_TRACKS = BUILDER.comment("Whether to render tracks").define("renderTracks", false);
    private static final ModConfigSpec.BooleanValue RENDER_CARRIAGES = BUILDER.comment("Whether to render carriages").define("renderCarriages", true);
    private static final ModConfigSpec.BooleanValue RENDER_TRAINS = BUILDER.comment("Whether to render trains").define("renderTrains", true);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int trainInterval;
    public static int trackInterval;
    public static boolean renderTracks;
    public static boolean renderCarriages;
    public static boolean renderTrains;

    private static void applyValues() {
        trainInterval = (Integer)INTERVAL_TRAINS.get();
        trackInterval = (Integer)INTERVAL_TRACKS.get();
        renderTracks = (Boolean)RENDER_TRACKS.get();
        renderCarriages = (Boolean)RENDER_CARRIAGES.get();
        renderTrains = (Boolean)RENDER_TRAINS.get();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        Config.applyValues();
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        Config.applyValues();
    }
}

