/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.visuals.trailing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import com.simibubi.create.foundation.render.SpecialModels;
import com.weido.create_bb.registry.BogiePartials;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class DoubleAxleTrailingVisual
implements BogeyVisual {
    public DoubleAxleTrailingVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
    }

    public void hide() {
    }

    public void updateLight(int packedLight) {
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    public void delete() {
    }

    public static class DoubleAxleSmallTrailing
    extends DoubleAxleTrailingVisual {
        private final TransformedInstance frame;
        private final TransformedInstance wheel1;
        private final TransformedInstance wheel2;
        private final TransformedInstance shaft1;
        private final TransformedInstance shaft2;
        private final TransformedInstance shaft3;
        private final TransformedInstance shaft4;

        public DoubleAxleSmallTrailing(VisualizationContext ctx, float partialTick, boolean inContraption) {
            super(ctx, partialTick, inContraption);
            Instancer wheelInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)BogiePartials.SMALL_SHARED_WHEELS));
            Instancer shaftInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SHAFT));
            Instancer t_shaftInstancer = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)AllPartialModels.SHAFT));
            this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.smoothLit((PartialModel)BogiePartials.SMALL_TRAILING_4_FRAME)).createInstance();
            this.wheel1 = (TransformedInstance)wheelInstancer.createInstance();
            this.wheel2 = (TransformedInstance)wheelInstancer.createInstance();
            this.shaft1 = (TransformedInstance)shaftInstancer.createInstance();
            this.shaft2 = (TransformedInstance)shaftInstancer.createInstance();
            this.shaft3 = (TransformedInstance)t_shaftInstancer.createInstance();
            this.shaft4 = (TransformedInstance)t_shaftInstancer.createInstance();
        }

        @Override
        public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
            super.update(bogeyData, wheelAngle, poseStack);
            ((TransformedInstance)this.frame.setTransform(poseStack).scale(0.9980469f)).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft1.setTransform(poseStack).translate(-0.5f, 0.25f, 0.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft2.setTransform(poseStack).translate(-0.5f, 0.25f, -1.0f).center()).rotateTo(Direction.UP, Direction.SOUTH)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft3.setTransform(poseStack).translate(-0.5f, 0.25f, 0.5f).center()).rotateTo(Direction.UP, Direction.EAST)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shaft4.setTransform(poseStack).translate(-0.5f, 0.25f, -1.5f).center()).rotateTo(Direction.UP, Direction.EAST)).rotateYDegrees(wheelAngle)).uncenter()).setChanged();
            ((TransformedInstance)this.wheel1.setTransform(poseStack).translate(0.0f, 0.75f, -1.0f).rotateXDegrees(wheelAngle)).setChanged();
            ((TransformedInstance)this.wheel2.setTransform(poseStack).translate(0.0f, 0.75f, 1.0f).rotateXDegrees(wheelAngle)).setChanged();
        }

        @Override
        public void hide() {
            super.hide();
            this.frame.setZeroTransform().setChanged();
            this.wheel1.setZeroTransform().setChanged();
            this.wheel2.setZeroTransform().setChanged();
            this.shaft1.setZeroTransform().setChanged();
            this.shaft2.setZeroTransform().setChanged();
            this.shaft3.setZeroTransform().setChanged();
            this.shaft4.setZeroTransform().setChanged();
        }

        @Override
        public void updateLight(int packedLight) {
            super.updateLight(packedLight);
            this.frame.light(packedLight).setChanged();
            this.wheel1.light(packedLight).setChanged();
            this.wheel2.light(packedLight).setChanged();
            this.shaft1.light(packedLight).setChanged();
            this.shaft2.light(packedLight).setChanged();
            this.shaft3.light(packedLight).setChanged();
            this.shaft4.light(packedLight).setChanged();
        }

        @Override
        public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
            super.collectCrumblingInstances(consumer);
            consumer.accept((Instance)this.frame);
            consumer.accept((Instance)this.wheel1);
            consumer.accept((Instance)this.wheel2);
            consumer.accept((Instance)this.shaft1);
            consumer.accept((Instance)this.shaft2);
            consumer.accept((Instance)this.shaft3);
            consumer.accept((Instance)this.shaft4);
        }

        @Override
        public void delete() {
            super.delete();
            this.frame.delete();
            this.wheel1.delete();
            this.wheel2.delete();
            this.shaft1.delete();
            this.shaft2.delete();
            this.shaft3.delete();
            this.shaft4.delete();
        }
    }
}

