/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data.menu.Input;

import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SizeScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Component.translatable((String)"create_bb.menu.scroll_selection");
    private final MutableComponent noOptionAvailable = Component.translatable((String)"create_bb.menu.no_options_available");
    private BogeySizes.BogeySize[] sizes = new BogeySizes.BogeySize[]{BogeySizes.SMALL, BogeySizes.LARGE};
    private boolean isDriver = false;

    public SizeScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.withRange(0, this.sizes.length).titled(Component.translatable((String)"create_bb.menu.size")).setState(0).inverted();
        this.updateTooltip();
    }

    public void setDriver(boolean isDriver) {
        this.isDriver = isDriver;
        this.updateTooltip();
    }

    public BogeySizes.BogeySize[] getSizes() {
        return this.sizes;
    }

    public void updateOptions(Set<BogeySizes.BogeySize> validSizes) {
        if (validSizes.isEmpty()) {
            validSizes.add(BogeySizes.SMALL);
        }
        this.sizes = validSizes.toArray(new BogeySizes.BogeySize[0]);
        this.withRange(0, this.sizes.length);
        this.state = Math.min(this.state, this.sizes.length);
        this.updateTooltip();
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title != null) {
            this.toolTip.add(this.title.copy().withStyle(s -> s.withColor(HEADER_RGB.getRGB())));
        }
        for (int i = 0; i < this.sizes.length; ++i) {
            MutableComponent sizeText = Component.empty().append(i == this.state ? "-> " : "> ").append((Component)Component.translatable((String)(this.sizes[i] == BogeySizes.LARGE ? (this.isDriver ? "create_bb.menu.size.extra_large" : "create_bb.menu.size.large") : (this.isDriver ? "create_bb.menu.size.large" : "create_bb.menu.size.small"))));
            this.toolTip.add(sizeText.withStyle(i == this.state ? ChatFormatting.WHITE : ChatFormatting.GRAY));
        }
        if (this.sizes.length == 1) {
            this.toolTip.add(this.noOptionAvailable.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            this.toolTip.add(this.scrollToSelect.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    public BogeySizes.BogeySize getCurrentSize() {
        return this.sizes[this.getState()];
    }
}

