/*
 * Decompiled with CFR 0.152.
 */
package com.weido.create_bb.data;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.weido.create_bb.blocks.BBBogieBlockEntity;
import com.weido.create_bb.data.packets.BogieMenuPacket;
import java.util.Random;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BogieFunctionality {
    public static ItemInteractionResult BogieRotationInteraction(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        BBBogieBlockEntity bogie;
        BBBogieBlockEntity be;
        if (BogieFunctionality.isInvalidInteraction(player, hand)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BBBogieBlockEntity bBBogieBlockEntity = be = blockEntity instanceof BBBogieBlockEntity ? (bogie = (BBBogieBlockEntity)blockEntity) : null;
        if (be == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.isShiftKeyDown()) {
            return BogieFunctionality.openMenu(level, player, pos);
        }
        return BogieFunctionality.rotateBogie(state, level, pos, player, be);
    }

    public static ItemInteractionResult BogeyMenuInteraction(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (BogieFunctionality.isInvalidInteraction(player, hand)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AbstractBogeyBlockEntity be = (AbstractBogeyBlockEntity)level.getBlockEntity(pos);
        if (be == null || !player.isShiftKeyDown()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return BogieFunctionality.openMenu(level, player, pos);
    }

    private static boolean isInvalidInteraction(Player player, InteractionHand hand) {
        return hand != InteractionHand.MAIN_HAND || !player.getItemInHand(hand).isEmpty();
    }

    private static ItemInteractionResult openMenu(Level level, Player player, BlockPos pos) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            new BogieMenuPacket.Serverbound(pos).handle(serverPlayer);
        }
        AllSoundEvents.SCROLL_VALUE.playOnServer(level, (Vec3i)pos, 1.0f, 1.0f);
        return ItemInteractionResult.CONSUME;
    }

    private static ItemInteractionResult rotateBogie(BlockState state, Level level, BlockPos pos, Player player, BBBogieBlockEntity be) {
        boolean newDirection;
        boolean isNewBogie;
        if (level.isClientSide) {
            return ItemInteractionResult.FAIL;
        }
        CompoundTag bogieData = be.getBogeyData();
        Direction assemblyDirection = (Direction)NBTHelper.readEnum((CompoundTag)bogieData, (String)"AssemblyDirection", Direction.class);
        boolean bl = isNewBogie = !bogieData.contains("IsForwards");
        boolean bl2 = isNewBogie ? BogieFunctionality.isDirectionPositive(assemblyDirection) : (newDirection = !bogieData.getBoolean("IsForwards"));
        if (!bogieData.contains("AssemblyDirection")) {
            NBTHelper.writeEnum((CompoundTag)bogieData, (String)"AssemblyDirection", (Enum)Direction.SOUTH);
        }
        if (level instanceof ServerLevel) {
            level.sendBlockUpdated(pos, state, state, 3);
            level.blockUpdated(pos, state.getBlock());
        }
        bogieData.putBoolean("IsForwards", newDirection);
        be.setBogeyData(bogieData);
        be.setChanged();
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, new Random().nextFloat() + 0.5f);
        player.displayClientMessage((Component)Component.translatable((String)"create_bb.tooltips.rotation"), true);
        return ItemInteractionResult.CONSUME;
    }

    private static boolean isDirectionPositive(Direction direction) {
        return direction == Direction.NORTH || direction == Direction.WEST || direction == Direction.UP;
    }
}

