/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.mixin.accessor.GameTestHelperAccessor;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CreateGameTestHelper
extends GameTestHelper {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TEN_SECONDS = 200;
    public static final int FIFTEEN_SECONDS = 300;
    public static final int TWENTY_SECONDS = 400;
    public static final int THIRTY_SECONDS = 600;

    private CreateGameTestHelper(GameTestInfo testInfo) {
        super(testInfo);
    }

    public static CreateGameTestHelper of(GameTestHelper original) {
        GameTestHelperAccessor access = (GameTestHelperAccessor)original;
        CreateGameTestHelper helper = new CreateGameTestHelper(access.getTestInfo());
        GameTestHelperAccessor newAccess = (GameTestHelperAccessor)((Object)helper);
        newAccess.setFinalCheckAdded(access.getFinalCheckAdded());
        return helper;
    }

    public void flipBlock(BlockPos pos) {
        BlockState original = this.getBlockState(pos);
        if (!original.hasProperty((Property)BlockStateProperties.FACING)) {
            this.fail("FACING property not in block: " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)original.getBlock())));
        }
        Direction facing = (Direction)original.getValue((Property)BlockStateProperties.FACING);
        BlockState reversed = (BlockState)original.setValue((Property)BlockStateProperties.FACING, (Comparable)facing.getOpposite());
        this.setBlock(pos, reversed);
    }

    public void assertNixiePower(BlockPos pos, int strength) {
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((BlockEntityType)AllBlockEntityTypes.NIXIE_TUBE.get(), pos);
        int actualStrength = nixie.getRedstoneStrength();
        if (actualStrength != strength) {
            this.fail("Expected nixie tube at %s to have power of %s, got %s".formatted(pos, strength, actualStrength));
        }
    }

    public void powerLever(BlockPos pos) {
        this.assertBlockPresent(Blocks.LEVER, pos);
        if (!((Boolean)this.getBlockState(pos).getValue((Property)LeverBlock.POWERED)).booleanValue()) {
            this.pullLever(pos);
        }
    }

    public void unpowerLever(BlockPos pos) {
        this.assertBlockPresent(Blocks.LEVER, pos);
        if (((Boolean)this.getBlockState(pos).getValue((Property)LeverBlock.POWERED)).booleanValue()) {
            this.pullLever(pos);
        }
    }

    public void setTunnelMode(BlockPos pos, BrassTunnelBlockEntity.SelectionMode mode) {
        ScrollValueBehaviour behavior = (ScrollValueBehaviour)this.getBehavior(pos, ScrollOptionBehaviour.TYPE);
        behavior.setValue(mode.ordinal());
    }

    public void assertSpeedometerSpeed(BlockPos speedometer, float value) {
        SpeedGaugeBlockEntity be = (SpeedGaugeBlockEntity)this.getBlockEntity((BlockEntityType)AllBlockEntityTypes.SPEEDOMETER.get(), speedometer);
        this.assertInRange(be.getSpeed(), (double)value - 0.01, (double)value + 0.01);
    }

    public void assertStressometerCapacity(BlockPos stressometer, float value) {
        StressGaugeBlockEntity be = (StressGaugeBlockEntity)this.getBlockEntity((BlockEntityType)AllBlockEntityTypes.STRESSOMETER.get(), stressometer);
        this.assertInRange(be.getNetworkCapacity(), (double)value - 0.01, (double)value + 0.01);
    }

    public void toggleActorsOfType(Contraption contraption, ItemLike item) {
        AtomicBoolean toggled = new AtomicBoolean(false);
        contraption.getInteractors().forEach((localPos, behavior) -> {
            if (toggled.get() || !(behavior instanceof ContraptionControlsMovingInteraction)) {
                return;
            }
            ContraptionControlsMovingInteraction controls = (ContraptionControlsMovingInteraction)behavior;
            MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor = contraption.getActorAt((BlockPos)localPos);
            if (actor == null) {
                return;
            }
            ItemStack filter = ContraptionControlsMovement.getFilter((MovementContext)actor.right);
            if (filter != null && filter.is(item.asItem())) {
                controls.handlePlayerInteraction(this.makeMockPlayer(GameType.CREATIVE), InteractionHand.MAIN_HAND, (BlockPos)localPos, contraption.entity);
                toggled.set(true);
            }
        });
    }

    public <T extends BlockEntity> T getBlockEntity(BlockEntityType<T> type, BlockPos pos) {
        BlockEntityType actualType;
        BlockEntity be = this.getBlockEntity(pos);
        BlockEntityType blockEntityType = actualType = be == null ? null : be.getType();
        if (actualType != type) {
            String actualId = actualType == null ? "null" : RegisteredObjectsHelper.getKeyOrThrow((BlockEntityType)actualType).toString();
            String error = "Expected block entity at pos [%s] with type [%s], got [%s]".formatted(pos, RegisteredObjectsHelper.getKeyOrThrow(type), actualId);
            this.fail(error);
        }
        return (T)be;
    }

    public <T extends BlockEntity> T getControllerBlockEntity(BlockEntityType<T> type, BlockPos anySegment) {
        Object be = ((IMultiBlockEntityContainer)this.getBlockEntity(type, anySegment)).getControllerBE();
        if (be == null) {
            this.fail("Could not get block entity controller with type [%s] from pos [%s]".formatted(RegisteredObjectsHelper.getKeyOrThrow(type), anySegment));
        }
        return be;
    }

    public <T extends BlockEntityBehaviour> T getBehavior(BlockPos pos, BehaviourType<T> type) {
        T behavior = BlockEntityBehaviour.get((BlockGetter)this.getLevel(), this.absolutePos(pos), type);
        if (behavior == null) {
            this.fail("Behavior at " + String.valueOf(pos) + " missing, expected " + type.getName());
        }
        return behavior;
    }

    public ItemEntity spawnItem(BlockPos pos, ItemStack stack) {
        Vec3 spawn = Vec3.atCenterOf((Vec3i)this.absolutePos(pos));
        ServerLevel level = this.getLevel();
        ItemEntity item = new ItemEntity((Level)level, spawn.x, spawn.y, spawn.z, stack, 0.0, 0.0, 0.0);
        level.addFreshEntity((Entity)item);
        return item;
    }

    public void spawnItems(BlockPos pos, Item item, int amount) {
        while (amount > 0) {
            int toSpawn = Math.min(amount, item.getMaxStackSize(new ItemStack((ItemLike)item)));
            amount -= toSpawn;
            ItemStack stack = new ItemStack((ItemLike)item, toSpawn);
            this.spawnItem(pos, stack);
        }
    }

    public <T extends Entity> T getFirstEntity(EntityType<T> type, BlockPos pos) {
        List<T> list = this.getEntitiesBetween(type, pos.north().east().above(), pos.south().west().below());
        if (list.isEmpty()) {
            this.fail("No entities at pos: " + String.valueOf(pos));
        }
        return (T)((Entity)list.get(0));
    }

    public <T extends Entity> List<T> getEntitiesBetween(EntityType<T> type, BlockPos pos1, BlockPos pos2) {
        BoundingBox box = BoundingBox.fromCorners((Vec3i)this.absolutePos(pos1), (Vec3i)this.absolutePos(pos2));
        List entities = this.getLevel().getEntities(type, e -> box.isInside((Vec3i)e.blockPosition()));
        return entities;
    }

    public IFluidHandler fluidStorageAt(BlockPos pos) {
        IFluidHandler handler;
        BlockEntity be = this.getBlockEntity(pos);
        if (be == null) {
            this.fail("BlockEntity not present");
        }
        if ((handler = (IFluidHandler)be.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), null)) == null) {
            this.fail("handler not present");
        }
        return handler;
    }

    public FluidStack getTankContents(BlockPos tank) {
        IFluidHandler handler = this.fluidStorageAt(tank);
        return handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
    }

    public long getTankCapacity(BlockPos pos) {
        IFluidHandler handler = this.fluidStorageAt(pos);
        long total = 0L;
        for (int i = 0; i < handler.getTanks(); ++i) {
            total += (long)handler.getTankCapacity(i);
        }
        return total;
    }

    public long getFluidInTanks(BlockPos ... tanks) {
        long total = 0L;
        for (BlockPos tank : tanks) {
            total += (long)this.getTankContents(tank).getAmount();
        }
        return total;
    }

    public void assertFluidPresent(FluidStack fluid, BlockPos pos) {
        FluidStack contained = this.getTankContents(pos);
        if (!FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)contained)) {
            this.fail("Different fluids");
        }
        if (fluid.getAmount() != contained.getAmount()) {
            this.fail("Different amounts");
        }
    }

    public void assertTankEmpty(BlockPos pos) {
        this.assertFluidPresent(FluidStack.EMPTY, pos);
    }

    public void assertTanksEmpty(BlockPos ... tanks) {
        for (BlockPos tank : tanks) {
            this.assertTankEmpty(tank);
        }
    }

    public IItemHandler itemStorageAt(BlockPos pos) {
        IItemHandler handler;
        BlockEntity be = this.getBlockEntity(pos);
        if (be == null) {
            this.fail("BlockEntity not present");
        }
        if ((handler = (IItemHandler)be.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), null)) == null) {
            this.fail("handler not present");
        }
        return handler;
    }

    public Object2LongMap<Item> getItemContent(BlockPos pos) {
        IItemHandler handler = this.itemStorageAt(pos);
        Object2LongArrayMap map = new Object2LongArrayMap();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            long amount = map.getLong((Object)item);
            map.put((Object)item, amount += (long)stack.getCount());
        }
        return map;
    }

    public long getTotalItems(BlockPos pos) {
        IItemHandler storage = this.itemStorageAt(pos);
        long total = 0L;
        for (int i = 0; i < storage.getSlots(); ++i) {
            total += (long)storage.getStackInSlot(i).getCount();
        }
        return total;
    }

    public void assertAnyContained(BlockPos pos, Item ... items) {
        IItemHandler handler = this.itemStorageAt(pos);
        boolean noneFound = true;
        block0: for (int i = 0; i < handler.getSlots(); ++i) {
            for (Item item : items) {
                if (!handler.getStackInSlot(i).is(item)) continue;
                noneFound = false;
                continue block0;
            }
        }
        if (noneFound) {
            this.fail("No matching items " + Arrays.toString(items) + " found in handler at pos: " + String.valueOf(pos));
        }
    }

    public void assertContentPresent(Object2LongMap<Item> content, BlockPos pos) {
        IItemHandler handler = this.itemStorageAt(pos);
        Object2LongArrayMap map = new Object2LongArrayMap(content);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            long amount = map.getLong((Object)item);
            if ((amount -= (long)stack.getCount()) == 0L) {
                map.removeLong((Object)item);
                continue;
            }
            map.put((Object)item, amount);
        }
        if (!map.isEmpty()) {
            this.fail("Storage missing content: " + String.valueOf(map));
        }
    }

    public void assertContainersEmpty(List<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.assertContainerEmpty(pos);
        }
    }

    public void assertContainerEmpty(@NotNull BlockPos pos) {
        IItemHandler storage = this.itemStorageAt(pos);
        for (int i = 0; i < storage.getSlots(); ++i) {
            if (storage.getStackInSlot(i).isEmpty()) continue;
            this.fail("Storage not empty");
        }
    }

    public void assertContainerContains(BlockPos pos, ItemLike item) {
        this.assertContainerContains(pos, item.asItem());
    }

    public void assertContainerContains(@NotNull BlockPos pos, @NotNull Item item) {
        this.assertContainerContains(pos, new ItemStack((ItemLike)item));
    }

    public void assertContainerContains(BlockPos pos, ItemStack item) {
        IItemHandler storage = this.itemStorageAt(pos);
        ItemStack extracted = ItemHelper.extract(storage, stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item), item.getCount(), true);
        if (extracted.isEmpty()) {
            this.fail("item not present: " + String.valueOf(item));
        }
    }

    public void assertSecondsPassed(int seconds) {
        if (this.getTick() < (long)seconds * 20L) {
            this.fail("Waiting for %s seconds to pass".formatted(seconds));
        }
    }

    public long secondsPassed() {
        return this.getTick() % 20L;
    }

    public void whenSecondsPassed(int seconds, Runnable run) {
        this.runAfterDelay((long)seconds * 20L, run);
    }

    public void assertCloseEnoughTo(double value, double expected) {
        this.assertInRange(value, expected - 1.0, expected + 1.0);
    }

    public void assertInRange(double value, double min, double max) {
        if (value < min) {
            this.fail("Value %s below expected min of %s".formatted(value, min));
        }
        if (value > max) {
            this.fail("Value %s greater than expected max of %s".formatted(value, max));
        }
    }

    @Contract(value="_->fail")
    public void fail(@NotNull String exceptionMessage) {
        super.fail(exceptionMessage);
    }
}

