/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.util;

import dev.wp.craftoria_core.util.CreativeSearchOrder;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public class Utils {
    public static volatile boolean emiReloading = false;
    public static volatile boolean updateBlockedByEmi = false;
    private static final int fluidOffset = 2147483;
    private static final int gasOffset = 21474830;

    public static int getItemPosition(ItemStack item) {
        if (emiReloading) {
            return BuiltInRegistries.ITEM.getId((Object)item.getItem());
        }
        return CreativeSearchOrder.getItemIndex(item);
    }

    public static int getFluidPos(Fluid fluid) {
        return 2147483 + BuiltInRegistries.FLUID.getId((Object)fluid);
    }

    public static int getChemicalPos(Chemical chemical) {
        return 21474830 + MekanismAPI.CHEMICAL_REGISTRY.getId((Object)chemical);
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static List<String> getModList() {
        return LoadingModList.get().getMods().stream().map(ModInfo::getModId).toList();
    }
}

