/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.util;

import java.util.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMatcher {
    private final boolean useComponents;
    @NotNull
    private final Item item;
    @Nullable
    private final DataComponentMap components;

    public ItemMatcher(@NotNull Item item, @Nullable DataComponentMap components, boolean useComponents) {
        this.item = item;
        this.components = components;
        this.useComponents = useComponents;
    }

    public static ItemMatcher of(@NotNull ItemStack item) {
        return new ItemMatcher(item.getItem(), item.getComponents(), true);
    }

    public static ItemMatcher ignoreNbt(@NotNull Item item) {
        return new ItemMatcher(item, null, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemMatcher)) {
            return false;
        }
        ItemMatcher other = (ItemMatcher)o;
        if (this.item != other.item) {
            return false;
        }
        if (!this.useComponents) {
            return true;
        }
        return Objects.equals(this.components, other.components);
    }

    public int hashCode() {
        return this.useComponents ? Objects.hash(this.item, this.components) : this.item.hashCode();
    }
}

