/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.util;

import dev.wp.craftoria_core.Craftoria;
import dev.wp.craftoria_core.util.ItemMatcher;
import dev.wp.craftoria_core.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class CreativeSearchOrder {
    private static final Map<ItemMatcher, Integer> itemOrderMap = new ConcurrentHashMap<ItemMatcher, Integer>();
    private static volatile boolean updatePending = false;

    private CreativeSearchOrder() {
    }

    public static int getItemIndex(ItemStack item) {
        Integer index = itemOrderMap.get(ItemMatcher.of(item));
        if (index != null) {
            return index;
        }
        index = itemOrderMap.get(ItemMatcher.ignoreNbt(item.getItem()));
        return index != null ? index : Integer.MAX_VALUE;
    }

    public static void scheduleUpdateIfNeeded() {
        if (Utils.emiReloading) {
            Utils.updateBlockedByEmi = true;
            Craftoria.LOGGER.debug("EMI reload in progress; skipping item order update");
            return;
        }
        if (!updatePending) {
            updatePending = true;
            CreativeSearchOrder.buildItemOrderMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildItemOrderMap() {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || mc.player == null) {
                return;
            }
            FeatureFlagSet flags = mc.level.enabledFeatures();
            boolean showOpItems = mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false;
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)flags, (boolean)showOpItems, (HolderLookup.Provider)mc.level.registryAccess());
            List<ItemStack> stacks = List.copyOf(CreativeModeTabs.searchTab().getDisplayItems());
            if (stacks.isEmpty()) {
                return;
            }
            ConcurrentHashMap<ItemMatcher, Integer> newMap = new ConcurrentHashMap<ItemMatcher, Integer>(stacks.size() * 2);
            int index = 0;
            for (ItemStack stack : stacks) {
                Item item = stack.getItem();
                ItemMatcher noNbt = ItemMatcher.ignoreNbt(item);
                if (!stack.hasFoil() || !newMap.containsKey(noNbt)) {
                    newMap.put(noNbt, index++);
                }
                newMap.put(ItemMatcher.of(stack), index++);
            }
            itemOrderMap.clear();
            itemOrderMap.putAll(newMap);
        }
        finally {
            updatePending = false;
        }
    }
}

