/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.mixin.cable_facades;

import com.portingdeadmods.cable_facades.CFConfig;
import com.portingdeadmods.cable_facades.content.items.FacadeItem;
import com.portingdeadmods.cable_facades.events.server.ServerInGameEvents;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={ServerInGameEvents.class})
public class ServerInGameEventsMixin {
    @SubscribeEvent
    @Overwrite
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos;
        Level level = event.getPlayer().level();
        if (FacadeUtils.hasFacade((BlockGetter)level, (BlockPos)(pos = event.getPos()))) {
            if (!level.isClientSide()) {
                BlockState facade = FacadeUtils.getFacade((BlockGetter)level, (BlockPos)pos);
                FacadeUtils.removeFacade((Level)level, (BlockPos)pos);
                Player player = event.getPlayer();
                if (!player.isCreative() && CFConfig.consumeFacade) {
                    ItemStack facadeStack = ((FacadeItem)CFItems.FACADE.get()).createFacade(facade.getBlock());
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)facadeStack);
                }
                event.setCanceled(true);
            }
            FacadeUtils.updateBlocks((Level)level, (BlockPos)pos);
        }
    }
}

