/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.mixin;

import dev.wp.craftoria_core.util.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private final Map<String, Boolean> modStatus = new HashMap<String, Boolean>();
    private final Map<String, String> mixinToMod = new HashMap<String, String>();
    private static final String BASE_PACKAGE = "dev.wp.craftoria_core.mixin.";

    private void setMixinToMod(String mixin, String mod) {
        this.mixinToMod.put(BASE_PACKAGE + mixin, mod);
    }

    public void onLoad(String s) {
        List<String> mods = Utils.getModList();
        boolean ae2AndEmi = mods.contains("ae2") && mods.contains("emi");
        boolean jdtAndIF = mods.contains("justdirethings") && mods.contains("industrialforegoing");
        this.modStatus.put("ae2emi", ae2AndEmi);
        this.modStatus.put("jdtAndIF", jdtAndIF);
        this.modStatus.put("cable_facades", mods.contains("cable_facades"));
        this.modStatus.put("xycraft_core", mods.contains("xycraft_core"));
        this.modStatus.put("cataclysm", mods.contains("cataclysm"));
        this.modStatus.put("jdt", mods.contains("justdirethings"));
        this.modStatus.put("curios", mods.contains("curios"));
        this.modStatus.put("buildinggadgets2", mods.contains("buildinggadgets2"));
        this.modStatus.put("sound_physics", mods.contains("sound_physics_remastered"));
        this.setMixinToMod("ae2.KeySortersMixin", "ae2emi");
        this.setMixinToMod("emi.ReloadWorkerMixin", "ae2emi");
        this.setMixinToMod("xycraft.XyCoreClientMixin", "xycraft_core");
        this.setMixinToMod("buildinggadgets2.BuildingGadgetsRenderDisable", "buildinggadgets2");
        this.setMixinToMod("sound_physics.SoundPhysicsMixin", "sound_physics");
        this.setMixinToMod("cable_facades.ServerInGameEventsMixin", "cable_facades");
        this.setMixinToMod("cataclysm.CursedTombstoneEntityMixin", "cataclysm");
        this.setMixinToMod("foregoing.EnchantmentExtractorTileMixin", "jdtAndIF");
        this.setMixinToMod("foregoing.MobCrusherTileMixin", "jdtAndIF");
        this.setMixinToMod("jdt.CreatureCatcherEntityMixin", "jdt");
        this.setMixinToMod("jdt.UnstablePortalFluidTypeMixin", "jdt");
        this.setMixinToMod("curios.CuriosEventHandlerMixin", "curios");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String modId = this.mixinToMod.get(mixinClassName);
        return modId == null || this.modStatus.getOrDefault(modId, false) != false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

