/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.datagen.client;

import dev.wp.craftoria_core.CItems;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class Lang
extends LanguageProvider {
    public Lang(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "craftoria_core", "en_us");
    }

    private static String key(String path) {
        return "craftoria_core." + path;
    }

    protected void addTranslations() {
        this.add(Lang.key("config.mixin_toggles"), "Mixin Toggles");
        this.add(Lang.key("config.disable_search_tab_autofocus"), "Disable Search Tab Autofocus");
        this.add(Lang.key("config.suppress_unknown_packet_id"), "Suppress Unknown Packet ID Errors");
        this.add(Lang.key("tooltip.contains"), "Contains: %s");
        this.add(Lang.key("tooltip.quantity"), "Quantity: %s");
        this.add(Lang.key("tooltip.empty"), "Empty");
        this.add(Lang.key("tooltip.partitioned"), "Partitioned for: %s");
        for (DeferredHolder item : CItems.ITEMS.getEntries()) {
            String key = item.getId().getPath();
            String formattedName = this.toMcFormat(key);
            this.add("item.%s.%s".formatted("craftoria_core", key), formattedName);
        }
    }

    private String toMcFormat(String key) {
        String[] parts = key.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String part : parts) {
            if (!formatted.isEmpty()) {
                formatted.append(" ");
            }
            formatted.append(part.substring(0, 1).toUpperCase()).append(part.substring(1).toLowerCase());
        }
        return formatted.toString();
    }
}

