/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.ae2.item.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import dev.wp.craftoria_core.ae2.init.AE2Components;
import dev.wp.craftoria_core.ae2.item.cell.BlackHoleCellItem;
import dev.wp.craftoria_core.ae2.item.cell.BlackHoleStorage;
import java.math.BigInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class BlackHoleStorageCell
implements StorageCell {
    private final ItemStack stack;
    private final ISaveProvider container;
    private final AEKeyType type;
    private AEKey storedItem;
    private final AEKey filterItem;
    private BigInteger count;
    private boolean isPersisted = true;

    public BlackHoleStorageCell(ItemStack stack, ISaveProvider container) {
        this.stack = stack;
        this.container = container;
        BlackHoleCellItem cell = (BlackHoleCellItem)stack.getItem();
        BlackHoleStorage storage = (BlackHoleStorage)stack.get(AE2Components.SINGULARITY_STORAGE);
        this.storedItem = storage != null ? storage.getStoredItem() : null;
        this.filterItem = cell.getConfigInventory(stack).getKey(0);
        this.type = cell.getKeyType();
        this.count = storage != null ? storage.getCount() : BigInteger.ZERO;
    }

    public AEKey getStoredItem() {
        return this.storedItem;
    }

    public AEKey getFilterItem() {
        return this.filterItem;
    }

    public BigInteger getCount() {
        return this.count;
    }

    public CellState getStatus() {
        if (this.filterItem != null) {
            return CellState.TYPES_FULL;
        }
        if (this.storedItem == null || this.count.signum() < 1) {
            return CellState.EMPTY;
        }
        return CellState.TYPES_FULL;
    }

    public double getIdleDrain() {
        return 25.0;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItem == null || this.count.signum() < 1) {
            this.stack.remove(AE2Components.SINGULARITY_STORAGE);
        } else {
            BlackHoleStorage storage = new BlackHoleStorage(this.storedItem, this.count);
            this.stack.set(AE2Components.SINGULARITY_STORAGE, (Object)storage);
        }
        this.isPersisted = true;
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L) {
            return 0L;
        }
        if (what.getType() != this.type) {
            return 0L;
        }
        if (this.filterItem != null && !this.filterItem.equals(what)) {
            return 0L;
        }
        if (this.storedItem != null && !what.equals(this.storedItem)) {
            return 0L;
        }
        BigInteger insertAmount = BigInteger.valueOf(amount);
        if (mode == Actionable.MODULATE) {
            if (this.storedItem == null) {
                this.storedItem = what;
            }
            this.count = this.count.add(insertAmount);
            this.saveChanges();
            return amount;
        }
        if (amount >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.count.signum() < 1) {
            return 0L;
        }
        if (this.storedItem == null) {
            return 0L;
        }
        if (!what.equals(this.storedItem)) {
            return 0L;
        }
        BigInteger currentCount = this.count;
        BigInteger extractAmount = BigInteger.valueOf(amount);
        if (currentCount.compareTo(extractAmount) <= 0) {
            if (mode == Actionable.MODULATE) {
                this.storedItem = null;
                this.count = BigInteger.ZERO;
                this.saveChanges();
            }
            return this.clampedLong(currentCount, Long.MAX_VALUE);
        }
        if (mode == Actionable.MODULATE) {
            this.count = this.count.subtract(extractAmount);
            this.saveChanges();
        }
        return this.clampedLong(extractAmount, Long.MAX_VALUE);
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedItem != null) {
            out.add(this.storedItem, this.clampedLong(this.count, Long.MAX_VALUE));
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return what.equals(this.storedItem) || what.equals(this.filterItem);
    }

    public boolean canFitInsideCell() {
        return this.filterItem == null && this.storedItem == null && this.count.signum() < 1;
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    private long clampedLong(BigInteger toClamp, long limit) {
        return toClamp.min(BigInteger.valueOf(limit)).longValue();
    }

    public long getStoredQuantity() {
        return this.clampedLong(this.count, Long.MAX_VALUE);
    }
}

