/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.ae2.item.cell;

import appeng.api.stacks.AEKey;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.math.BigInteger;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public class BlackHoleStorage {
    public static final Codec<BlackHoleStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AEKey.CODEC.fieldOf("key").forGetter(BlackHoleStorage::getStoredItem), (App)Codec.STRING.flatXmap(it -> {
        try {
            return DataResult.success((Object)new BigInteger((String)it));
        }
        catch (NumberFormatException e) {
            return DataResult.success((Object)BigInteger.ZERO);
        }
    }, it -> DataResult.success((Object)it.toString())).fieldOf("count").forGetter(BlackHoleStorage::getCount)).apply((Applicative)instance, BlackHoleStorage::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlackHoleStorage> STREAM_CODEC = StreamCodec.ofMember(BlackHoleStorage::encode, BlackHoleStorage::new);
    @Nullable
    private final AEKey storedItem;
    private final BigInteger count;

    public BlackHoleStorage(@Nullable AEKey storedItem, BigInteger count) {
        this.storedItem = storedItem;
        this.count = count;
    }

    public BlackHoleStorage(RegistryFriendlyByteBuf buf) {
        BigInteger c;
        this.storedItem = AEKey.readOptionalKey((RegistryFriendlyByteBuf)buf);
        String integerStr = buf.readUtf();
        try {
            c = new BigInteger(integerStr);
        }
        catch (NumberFormatException e) {
            c = BigInteger.ZERO;
        }
        this.count = c;
    }

    @Nullable
    public AEKey getStoredItem() {
        return this.storedItem;
    }

    public BigInteger getCount() {
        return this.count;
    }

    public void encode(RegistryFriendlyByteBuf buf) {
        AEKey.writeOptionalKey((RegistryFriendlyByteBuf)buf, (AEKey)this.storedItem);
        buf.writeUtf(this.count.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlackHoleStorage) {
            BlackHoleStorage storage = (BlackHoleStorage)obj;
            return Objects.equals(storage.getStoredItem(), this.getStoredItem()) && Objects.equals(storage.getCount(), this.getCount());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getStoredItem(), this.getCount());
    }
}

