/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.craftoria_core.ae2.item.cell;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import dev.wp.craftoria_core.ae2.item.cell.BlackHoleStorageCell;
import dev.wp.craftoria_core.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlackHoleCellItem
extends AEBaseItem
implements ICellWorkbenchItem {
    public static final Handler HANDLER = new Handler();
    private final AEKeyType keyType;
    private final ItemLike coreItem;
    private final ItemLike housingItem;

    public BlackHoleCellItem(Item.Properties properties, AEKeyType keyType, ItemLike coreItem, ItemLike housingItem) {
        super(properties.stacksTo(1));
        this.keyType = keyType;
        this.coreItem = coreItem;
        this.housingItem = housingItem;
    }

    public AEKeyType getKeyType() {
        return this.keyType;
    }

    public ItemLike getCoreItem() {
        return this.coreItem;
    }

    public ItemLike getHousingItem() {
        return this.housingItem;
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(Set.of(this.keyType), (ItemStack)is, (int)1);
    }

    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem((ItemStack)stack, (int)1);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return null;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        @Nullable BlackHoleStorageCell inv = HANDLER.getCellInventory(stack, null);
        if (inv != null) {
            AEKey storedItem = inv.getStoredItem();
            AEKey filterItem = inv.getFilterItem();
            if (storedItem != null) {
                lines.add((Component)Component.translatable((String)"%s.tooltip.contains".formatted("craftoria_core"), (Object[])new Object[]{storedItem.getDisplayName()}));
                lines.add((Component)Component.translatable((String)"%s.tooltip.quantity".formatted("craftoria_core"), (Object[])new Object[]{NumberUtil.numberText(inv.getCount())}));
            } else {
                lines.add((Component)Component.translatable((String)"%s.tooltip.empty".formatted("craftoria_core")));
            }
            if (filterItem != null && storedItem == null) {
                lines.add((Component)Component.translatable((String)"%s.tooltip.partitioned".formatted("craftoria_core"), (Object[])new Object[]{filterItem.getDisplayName()}));
            }
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        @Nullable BlackHoleStorageCell inv = HANDLER.getCellInventory(stack, null);
        if (inv == null) {
            return Optional.empty();
        }
        ArrayList upgrades = new ArrayList();
        ArrayList<GenericStack> content = new ArrayList<GenericStack>();
        if (AEConfig.instance().isTooltipShowCellContent()) {
            if (inv.getStoredItem() != null) {
                content.add(new GenericStack(inv.getStoredItem(), inv.getStoredQuantity()));
            } else if (inv.getFilterItem() != null) {
                content.add(new GenericStack(inv.getFilterItem(), 0L));
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, false, true));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        this.disassembleDrive(player.getItemInHand(usedHand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(usedHand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            if (level.isClientSide()) {
                return false;
            }
            Inventory playerInventory = player.getInventory();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && playerInventory.getSelected() == stack) {
                KeyCounter list = inv.getAvailableStacks();
                if (list.isEmpty()) {
                    playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
                    playerInventory.placeItemBackInInventory(new ItemStack(this.coreItem));
                    for (ItemStack upgrade : this.getUpgrades(stack)) {
                        playerInventory.placeItemBackInInventory(upgrade);
                    }
                    playerInventory.placeItemBackInInventory(new ItemStack(this.housingItem));
                    return true;
                }
                player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }

    public static class Handler
    implements ICellHandler {
        public boolean isCell(ItemStack is) {
            return is != null && is.getItem() instanceof BlackHoleCellItem;
        }

        @Nullable
        public BlackHoleStorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new BlackHoleStorageCell(is, host) : null;
        }
    }
}

